/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourcePathTypeResolver
implements TypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePathTypeResolver.class);
    private static final String INSTANCE = "INSTANCE";
    private final String resourceBasePath;
    private final List<String> zipEntriesAsString = new ArrayList<String>();

    public ResourcePathTypeResolver() {
        this("META-INF");
    }

    public ResourcePathTypeResolver(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath.endsWith("/") ? resourceBasePath.substring(0, resourceBasePath.length() - 1) : resourceBasePath;
    }

    @Override
    public String resolveProperty(String resourcePath, String property) {
        return this.readAsProperties(resourcePath).getProperty(property);
    }

    @Override
    public <T> T resolve(String resourcePath, String property, Object ... initargs) {
        String type = this.resolveProperty(resourcePath, property);
        try {
            if (initargs.length == 0) {
                return (T)Class.forName(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)this.getConstructor(Class.forName(type), initargs).newInstance(initargs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            try {
                if (Arrays.stream(Class.forName(type).getFields()).anyMatch(f -> f.getName().equals(INSTANCE) && Modifier.isStatic(f.getModifiers()))) {
                    return (T)Class.forName(type).getField(INSTANCE).get(null);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e1) {
                throw new CitrusRuntimeException(String.format("Failed to resolve classpath resource of type '%s'", type), e1);
            }
            LOG.warn(String.format("Neither static instance nor accessible default constructor (%s) is given on type '%s'", Arrays.toString(this.getParameterTypes(initargs)), type));
            throw new CitrusRuntimeException(String.format("Failed to resolve classpath resource of type '%s'", type), e);
        }
    }

    @Override
    public <T> Map<String, T> resolveAll(String resourcePath, String property, String keyProperty) {
        HashMap resources = new HashMap();
        String path = this.getFullResourcePath(resourcePath);
        try {
            Stream.concat(Stream.of(new PathMatchingResourcePatternResolver().getResources("classpath*:" + path + "/*")), this.resolveAllFromJar(path)).forEach(file -> {
                Optional<String> resourceName = Optional.ofNullable(file.getFilename());
                if (resourceName.isEmpty()) {
                    LOG.warn(String.format("Skip unsupported resource '%s' for resource lookup", file));
                    return;
                }
                if (property.equals("*")) {
                    Properties properties = this.readAsProperties(path + "/" + resourceName.get());
                    for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                        Object resource = this.resolve(path + "/" + resourceName.get(), prop.getKey().toString(), new Object[0]);
                        resources.put(resourceName.get() + "." + prop.getKey().toString(), resource);
                    }
                } else {
                    Object resource = this.resolve(path + "/" + resourceName.get(), property, new Object[0]);
                    if (keyProperty != null) {
                        resources.put(this.resolveProperty(path + "/" + resourceName.get(), keyProperty), resource);
                    } else {
                        resources.put(resourceName.get(), resource);
                    }
                }
            });
        }
        catch (IOException e) {
            LOG.warn(String.format("Failed to resolve resources in '%s'", path), (Throwable)e);
        }
        return resources;
    }

    private Stream<Resource> resolveAllFromJar(String path) {
        String rootAsString = ResourcePathTypeResolver.class.getProtectionDomain().getCodeSource().getLocation().toString();
        ClassLoader classLoader = Objects.requireNonNull(ResourcePathTypeResolver.class.getClassLoader());
        if (rootAsString.endsWith(".jar") && !rootAsString.matches(".*" + File.separator + "citrus-api-\\d+\\.\\d+\\.\\d+(-.*)?\\.jar")) {
            return this.getZipEntries().stream().filter(entry -> entry.startsWith(path)).map(classLoader::getResource).filter(Objects::nonNull).map(UrlResource::new);
        }
        return Stream.of(new Resource[0]);
    }

    private List<String> getZipEntries() {
        if (this.zipEntriesAsString.isEmpty()) {
            URL root = ResourcePathTypeResolver.class.getProtectionDomain().getCodeSource().getLocation();
            try (ZipInputStream in = new ZipInputStream(root.openStream());){
                ZipEntry entry;
                while ((entry = in.getNextEntry()) != null) {
                    this.zipEntriesAsString.add(entry.getName());
                }
            }
            catch (IOException e) {
                LOG.warn(String.format("Failed to open '%s'", root), (Throwable)e);
            }
        }
        return this.zipEntriesAsString;
    }

    private Constructor<?> getConstructor(Class<?> type, Object[] initargs) {
        Object[] parameterTypes = this.getParameterTypes(initargs);
        Optional<Constructor> exactMatch = Arrays.stream(type.getDeclaredConstructors()).filter(arg_0 -> ResourcePathTypeResolver.lambda$getConstructor$3((Class[])parameterTypes, arg_0)).findFirst();
        if (exactMatch.isPresent()) {
            return exactMatch.get();
        }
        Optional<Constructor> match = Arrays.stream(type.getDeclaredConstructors()).filter(arg_0 -> ResourcePathTypeResolver.lambda$getConstructor$4((Class[])parameterTypes, arg_0)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        throw new IllegalArgumentException(String.format("No matching constructor found for type %s and parameters %s", type.getName(), Arrays.toString(parameterTypes)));
    }

    private Properties readAsProperties(String resourcePath) {
        String path = this.getFullResourcePath(resourcePath);
        InputStream in = ResourcePathTypeResolver.class.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            throw new CitrusRuntimeException(String.format("Failed to locate resource path '%s'", path));
        }
        try {
            Properties config = new Properties();
            config.load(in);
            return config;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Unable to load properties from resource path configuration at '%s'", path), e);
        }
    }

    private String getFullResourcePath(String resourcePath) {
        if (resourcePath == null || resourcePath.length() == 0) {
            return this.resourceBasePath;
        }
        if (!resourcePath.startsWith(this.resourceBasePath)) {
            return this.resourceBasePath + "/" + resourcePath;
        }
        return resourcePath;
    }

    private Class<?>[] getParameterTypes(Object ... initargs) {
        return (Class[])Arrays.stream(initargs).map(Object::getClass).toArray(Class[]::new);
    }

    private static /* synthetic */ boolean lambda$getConstructor$4(Class[] parameterTypes, Constructor constructor) {
        if (constructor.getParameterCount() != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (constructor.getParameterTypes()[i].isAssignableFrom(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getConstructor$3(Class[] parameterTypes, Constructor constructor) {
        return Arrays.equals(constructor.getParameterTypes(), parameterTypes);
    }
}

