/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.DefaultMessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.springframework.util.StringUtils;

public class DefaultEmptyMessageValidator
extends DefaultMessageValidator {
    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) {
        if (controlMessage == null || controlMessage.getPayload() == null) {
            this.log.debug("Skip message payload validation as no control message was defined");
            return;
        }
        if (StringUtils.hasText((String)controlMessage.getPayload(String.class))) {
            throw new ValidationException("Empty message validation failed - control message is not empty!");
        }
        this.log.debug("Start to verify empty message payload ...");
        if (StringUtils.hasText((String)receivedMessage.getPayload(String.class))) {
            throw new ValidationException("Validation failed - received message content is not empty!");
        }
        this.log.info("Message payload is empty as expected: All values OK");
    }
}

