/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.SchemaValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchemaValidator<T extends SchemaValidationContext> {
    public static final Logger LOG = LoggerFactory.getLogger(MessageValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/schemaValidator";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/schemaValidator");

    public static Map<String, SchemaValidator<? extends SchemaValidationContext>> lookup() {
        Map<String, SchemaValidator<? extends SchemaValidationContext>> validators = TYPE_RESOLVER.resolveAll("", "type", "name");
        if (LOG.isDebugEnabled()) {
            validators.forEach((k, v) -> LOG.debug(String.format("Found message validator '%s' as %s", k, v.getClass())));
        }
        return validators;
    }

    public static Optional<SchemaValidator<? extends SchemaValidationContext>> lookup(String validator) {
        try {
            SchemaValidator instance = (SchemaValidator)TYPE_RESOLVER.resolve(validator, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve validator from resource '%s/%s'", RESOURCE_PATH, validator));
            return Optional.empty();
        }
    }

    public void validate(Message var1, TestContext var2, T var3);

    public boolean supportsMessageType(String var1, Message var2);
}

