/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathResourceResolver.class);

    public Set<Path> getClasses(String path) throws IOException {
        LinkedHashSet<Path> resources = new LinkedHashSet<Path>(16);
        for (ClassLoader classLoader : this.getClassLoaders()) {
            this.findResources(path, classLoader, resources, name -> name.endsWith(".class"));
        }
        return resources;
    }

    public Set<Path> getResources(String path) throws IOException {
        LinkedHashSet<Path> resources = new LinkedHashSet<Path>(16);
        if (path.endsWith("/*")) {
            path = path.substring(0, path.length() - 1);
        } else if (path.endsWith(".*")) {
            path = path.substring(0, path.length() - 2);
        }
        if (path.startsWith("classpath:")) {
            path = path.substring("classpath:".length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (ClassLoader classLoader : this.getClassLoaders()) {
            this.findResources(path, classLoader, resources, name -> !name.endsWith(".class"));
        }
        return resources;
    }

    public Set<Path> getResources(String path, String fileNamePattern) throws IOException {
        return this.getResources(path).stream().filter(resource -> resource.getFileName().toString().matches(fileNamePattern)).collect(Collectors.toSet());
    }

    private void findResources(String path, ClassLoader classLoader, Set<Path> result, Predicate<String> filter) throws IOException {
        Object resourcePath = !path.isEmpty() && !path.endsWith("/") ? path.replace(".", "/") + "/" : path.replace(".", "/");
        Enumeration<URL> urls = classLoader.getResources((String)resourcePath);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            try {
                String urlPath = this.parseUrlPath(url);
                if (urlPath == null) continue;
                logger.debug("Scanning for resources in: {}", (Object)urlPath);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.loadResourcesInDirectory((String)resourcePath, file, result, filter);
                    continue;
                }
                this.loadResourcesInJar(classLoader, (String)resourcePath, new FileInputStream(file), urlPath, result, filter);
            }
            catch (IOException e) {
                logger.debug("Failed to read entries in url: {}", (Object)url, (Object)e);
            }
        }
    }

    private void loadResourcesInJar(ClassLoader classLoader, String path, FileInputStream jarInputStream, String urlPath, Set<Path> resources, Predicate<String> filter) {
        ArrayList<String> entries = new ArrayList<String>();
        try (JarInputStream jarStream = new JarInputStream(jarInputStream);){
            JarEntry entry;
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName().trim();
                if (entry.isDirectory() || !filter.test(name) || !name.startsWith(path)) continue;
                entries.add(name);
            }
            for (String name : entries) {
                String shortName = name.substring(path.length());
                logger.trace("Found resource: {} in {}", (Object)shortName, (Object)urlPath);
                URL url = classLoader.getResource(name);
                if (url == null) continue;
                resources.add(Paths.get(name, new String[0]));
            }
        }
        catch (IOException e) {
            logger.warn("Cannot search jar file '{} due to an IOException: {}", new Object[]{urlPath, e.getMessage(), e});
        }
    }

    private void loadResourcesInDirectory(String path, File location, Set<Path> result, Predicate<String> filter) {
        File[] files = location.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            StringBuilder builder = new StringBuilder(100);
            String name = file.getName().trim();
            if (file.isDirectory()) {
                this.loadResourcesInDirectory(builder.append(path).append(name).append("/").toString(), file, result, filter);
                continue;
            }
            if (!file.isFile() || !file.exists() || !filter.test(name)) continue;
            logger.trace("Found resource: {} as {}", (Object)name, (Object)file.toURI());
            result.add(Paths.get(builder.append(path).append(name).toString(), new String[0]));
        }
    }

    private String parseUrlPath(URL url) {
        String urlPath = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8);
        if (urlPath.startsWith("file:")) {
            try {
                urlPath = new URI(url.getFile()).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (urlPath.startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
        }
        if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
            logger.trace("Skipping OSGi bundle: {}", (Object)url);
            return null;
        }
        if (url.toString().startsWith("bundleresource:") || urlPath.startsWith("bundleresource:")) {
            logger.trace("Skipping bundleresource: {}", (Object)url);
            return null;
        }
        return urlPath.contains("!") ? urlPath.substring(0, urlPath.indexOf("!")) : urlPath;
    }

    private Set<ClassLoader> getClassLoaders() {
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                classLoaders.add(ccl);
            }
        }
        catch (Exception e) {
            logger.warn("Cannot add ContextClassLoader from current thread due {}. This exception will be ignored", (Object)e.getMessage());
        }
        classLoaders.add(ClasspathResourceResolver.class.getClassLoader());
        return classLoaders;
    }
}

