/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import org.citrusframework.CitrusSettings;

public interface Resource {
    public String getLocation();

    public boolean exists();

    default public URI getURI() {
        return URI.create(this.getLocation());
    }

    default public URL getURL() throws MalformedURLException {
        URI uri = this.getURI();
        return uri != null ? uri.toURL() : null;
    }

    public InputStream getInputStream();

    public File getFile();

    default public Reader getReader() throws IOException {
        return this.getReader(Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING));
    }

    default public Reader getReader(Charset charset) throws IOException {
        return new InputStreamReader(this.getInputStream(), charset);
    }
}

