/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import org.citrusframework.TestSource;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class TestClass
extends TestSource {
    private final String method;

    public TestClass(Class<?> type) {
        this(type, null);
    }

    public TestClass(Class<?> type, String method) {
        super(type);
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public static TestClass fromString(String testClass) {
        try {
            String className;
            String methodName = null;
            if (testClass.contains("#")) {
                className = testClass.substring(0, testClass.indexOf("#"));
                methodName = testClass.substring(testClass.indexOf("#") + 1);
            } else {
                className = testClass;
            }
            if (methodName != null && !methodName.isBlank()) {
                return new TestClass(Class.forName(className), methodName);
            }
            return new TestClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new CitrusRuntimeException("Failed to create test class", e);
        }
    }
}

