/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml.namespace;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.citrusframework.message.Message;
import org.citrusframework.xml.namespace.DefaultNamespaceContext;

public class NamespaceContextBuilder {
    public static final String DEFAULT_BEAN_ID = "namespaceContextBuilder";
    private Map<String, String> namespaceMappings = new HashMap<String, String>();

    public NamespaceContext buildContext(Message receivedMessage, Map<String, String> namespaces) {
        DefaultNamespaceContext defaultNamespaceContext = new DefaultNamespaceContext();
        if (this.namespaceMappings.size() > 0) {
            defaultNamespaceContext.addNamespaces(this.namespaceMappings);
        }
        Map<String, String> dynamicBindings = NamespaceContextBuilder.lookupNamespaces(receivedMessage.getPayload(String.class));
        if (namespaces != null && !namespaces.isEmpty()) {
            for (Map.Entry<String, String> binding : dynamicBindings.entrySet()) {
                if (namespaces.containsValue(binding.getValue())) continue;
                defaultNamespaceContext.addNamespace(binding.getKey(), binding.getValue());
            }
            defaultNamespaceContext.addNamespaces(namespaces);
        } else {
            defaultNamespaceContext.addNamespaces(dynamicBindings);
        }
        return defaultNamespaceContext;
    }

    public void setNamespaceMappings(Map<String, String> defaultMappings) {
        this.namespaceMappings = defaultMappings;
    }

    public Map<String, String> getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public static Map<String, String> lookupNamespaces(String xml) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        if (xml.contains("xmlns")) {
            String[] tokens = xml.split("xmlns", 2);
            do {
                String nsUri;
                String nsPrefix;
                String token;
                if ((token = tokens[1]).startsWith(":")) {
                    nsPrefix = token.substring(1, token.indexOf(61));
                } else if (token.startsWith("=")) {
                    nsPrefix = "";
                } else {
                    tokens = token.split("xmlns", 2);
                    continue;
                }
                try {
                    nsUri = token.substring(token.indexOf(34) + 1, token.indexOf(34, token.indexOf(34) + 1));
                }
                catch (StringIndexOutOfBoundsException e) {
                    nsUri = token.substring(token.indexOf(39) + 1, token.indexOf(39, token.indexOf(39) + 1));
                }
                namespaces.put(nsPrefix, nsUri);
                tokens = token.split("xmlns", 2);
            } while (tokens.length > 1);
        }
        return namespaces;
    }
}

