/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.exceptions.NoSuchFunctionException;
import org.citrusframework.functions.Function;

public class FunctionLibrary {
    private Map<String, Function> members = new HashMap<String, Function>();
    private static final String DEFAULT_PREFIX = "citrus:";
    private String name = "citrus:";
    private String prefix = "citrus:";

    public Function getFunction(String functionName) throws NoSuchFunctionException {
        if (!this.members.containsKey(functionName)) {
            throw new NoSuchFunctionException("Can not find function " + functionName + " in library " + this.name + " (" + this.prefix + ")");
        }
        return this.members.get(functionName);
    }

    public boolean knowsFunction(String functionName) {
        String functionPrefix = functionName.substring(0, functionName.indexOf(58) + 1);
        if (!functionPrefix.equals(this.prefix)) {
            return false;
        }
        return this.members.containsKey(functionName.substring(functionName.indexOf(58) + 1, functionName.indexOf(40)));
    }

    public void setMembers(Map<String, Function> members) {
        this.members = members;
    }

    public Map<String, Function> getMembers() {
        return this.members;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

