/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions;

import java.util.Objects;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.FunctionLibrary;
import org.citrusframework.functions.FunctionParameterHelper;
import org.citrusframework.variable.VariableUtils;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    public static String replaceFunctionsInString(String str, TestContext context) {
        return FunctionUtils.replaceFunctionsInString(str, context, false);
    }

    public static String replaceFunctionsInString(String stringValue, TestContext context, boolean enableQuoting) {
        if (stringValue == null || stringValue.isBlank() || stringValue.indexOf(58) < 0 || stringValue.indexOf(40) < 0 || stringValue.indexOf(41) < 0) {
            return stringValue;
        }
        String newString = stringValue;
        StringBuilder strBuffer = new StringBuilder();
        StringBuilder variableNameBuf = new StringBuilder();
        for (FunctionLibrary library : context.getFunctionRegistry().getFunctionLibraries()) {
            int searchIndex;
            int startIndex = 0;
            while ((searchIndex = newString.indexOf(library.getPrefix(), startIndex)) != -1) {
                int curIndex;
                int control = -1;
                boolean isVarComplete = false;
                for (curIndex = searchIndex; curIndex < newString.length() && !isVarComplete; ++curIndex) {
                    if (newString.indexOf(40, curIndex) == curIndex) {
                        ++control;
                    }
                    if (newString.charAt(curIndex) == ')' || curIndex == newString.length() - 1) {
                        if (control == 0) {
                            isVarComplete = true;
                        } else {
                            --control;
                        }
                    }
                    variableNameBuf.append(newString.charAt(curIndex));
                }
                String value = FunctionUtils.resolveFunction(variableNameBuf.toString(), context);
                strBuffer.append(newString, startIndex, searchIndex);
                if (enableQuoting) {
                    strBuffer.append("'" + value + "'");
                } else {
                    strBuffer.append(value);
                }
                startIndex = curIndex;
                variableNameBuf = new StringBuilder();
            }
            strBuffer.append(newString.substring(startIndex));
            newString = strBuffer.toString();
            strBuffer = new StringBuilder();
        }
        return newString;
    }

    public static String resolveFunction(String functionString, TestContext context) {
        String functionExpression = VariableUtils.cutOffVariablesPrefix(functionString);
        if (!(functionExpression.contains("(") && functionExpression.endsWith(")") && functionExpression.contains(":"))) {
            throw new InvalidFunctionUsageException("Unable to resolve function: " + functionExpression);
        }
        String functionPrefix = functionExpression.substring(0, functionExpression.indexOf(58) + 1);
        String parameterString = functionExpression.substring(functionExpression.indexOf(40) + 1, functionExpression.length() - 1);
        String function = functionExpression.substring(functionPrefix.length(), functionExpression.indexOf(40));
        FunctionLibrary library = context.getFunctionRegistry().getLibraryForPrefix(functionPrefix);
        parameterString = VariableUtils.replaceVariablesInString(parameterString, context, false);
        parameterString = FunctionUtils.replaceFunctionsInString(parameterString, context);
        String value = library.getFunction(function).execute(FunctionParameterHelper.getParameterList(parameterString), context);
        return Objects.requireNonNullElse(value, "");
    }
}

