/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ScriptPayloadBuilder
extends MessagePayloadBuilder {
    public static final Logger logger = LoggerFactory.getLogger(ScriptPayloadBuilder.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/script/message/builder";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/script/message/builder");

    public static <T extends ScriptPayloadBuilder> Optional<T> lookup(String type) {
        try {
            ScriptPayloadBuilder instance = (ScriptPayloadBuilder)TYPE_RESOLVER.resolve(type, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn(String.format("Failed to resolve script payload builder from resource '%s/%s'", RESOURCE_PATH, type));
            return Optional.empty();
        }
    }

    public void setScript(String var1);

    public void setFile(String var1);

    public void setFile(String var1, String var2);
}

