/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface ValidationMatcher {
    public static final Logger logger = LoggerFactory.getLogger(ValidationMatcher.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/validation/matcher";
    public static final Map<String, ValidationMatcher> matcher = new HashMap<String, ValidationMatcher>();

    public static Map<String, ValidationMatcher> lookup() {
        if (matcher.isEmpty()) {
            matcher.putAll(new ResourcePathTypeResolver().resolveAll(RESOURCE_PATH));
            if (logger.isDebugEnabled()) {
                matcher.forEach((k, v) -> logger.debug(String.format("Found validation matcher '%s' as %s", k, v.getClass())));
            }
        }
        return matcher;
    }

    public void validate(String var1, String var2, List<String> var3, TestContext var4) throws ValidationException;
}

