/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.exceptions.NoSuchValidationMatcherException;
import org.citrusframework.validation.matcher.ValidationMatcher;

public class ValidationMatcherLibrary {
    private Map<String, ValidationMatcher> members = new HashMap<String, ValidationMatcher>();
    private String name = "standard";
    private String prefix = "";

    public ValidationMatcher getValidationMatcher(String validationMatcherName) throws NoSuchValidationMatcherException {
        if (!this.members.containsKey(validationMatcherName)) {
            throw new NoSuchValidationMatcherException("Can not find validation matcher " + validationMatcherName + " in library " + this.name + " (" + this.prefix + ")");
        }
        return this.members.get(validationMatcherName);
    }

    public boolean knowsValidationMatcher(String validationMatcherName) {
        if (validationMatcherName.contains(":")) {
            String validationMatcherPrefix = validationMatcherName.substring(0, validationMatcherName.indexOf(58) + 1);
            if (!validationMatcherPrefix.equals(this.prefix)) {
                return false;
            }
            return this.members.containsKey(validationMatcherName.substring(validationMatcherName.indexOf(58) + 1, validationMatcherName.indexOf(40)));
        }
        return this.members.containsKey(validationMatcherName.substring(0, validationMatcherName.indexOf(40)));
    }

    public void setMembers(Map<String, ValidationMatcher> members) {
        this.members = members;
    }

    public Map<String, ValidationMatcher> getMembers() {
        return this.members;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

