/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HeaderValidator {
    public static final Logger logger = LoggerFactory.getLogger(HeaderValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/header/validator";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/header/validator");
    public static final Map<String, HeaderValidator> validators = new HashMap<String, HeaderValidator>();

    public static Map<String, HeaderValidator> lookup() {
        if (validators.isEmpty()) {
            validators.putAll(TYPE_RESOLVER.resolveAll("", "type", "name"));
            if (logger.isDebugEnabled()) {
                validators.forEach((k, v) -> logger.debug(String.format("Found header validator '%s' as %s", k, v.getClass())));
            }
        }
        return validators;
    }

    public static Optional<HeaderValidator> lookup(String validator) {
        try {
            HeaderValidator instance = (HeaderValidator)TYPE_RESOLVER.resolve(validator, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn(String.format("Failed to resolve header validator from resource '%s/%s'", RESOURCE_PATH, validator));
            return Optional.empty();
        }
    }

    public boolean supports(String var1, Class<?> var2);

    public void validateHeader(String var1, Object var2, Object var3, TestContext var4, HeaderValidationContext var5);
}

