/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.citrusframework.TestResult;

public class TestResults {
    private static final String ZERO_PERCENTAGE = "0.0";
    private final Set<TestResult> results = Collections.synchronizedSet(new LinkedHashSet());

    public List<TestResult> asList() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        this.doWithResults(results::add);
        return results;
    }

    public boolean addResult(TestResult result) {
        return this.results.add(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWithResults(ResultCallback callback) {
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult result : this.results) {
                callback.doWithResult(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuccess() {
        int count = 0;
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult testResult : this.results) {
                if (!testResult.isSuccess()) continue;
                ++count;
            }
        }
        return count;
    }

    @Deprecated
    public String getSuccessPercentage() {
        return this.getSuccessPercentageFormatted();
    }

    public String getSuccessPercentageFormatted() {
        return this.results.isEmpty() || this.getSuccess() == 0 ? ZERO_PERCENTAGE : this.getNewDecimalFormat().format((double)this.getSuccess() / (double)(this.getFailed() + this.getSuccess()) * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFailed() {
        int count = 0;
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult testResult : this.results) {
                if (!testResult.isFailed()) continue;
                ++count;
            }
        }
        return count;
    }

    @Deprecated
    public String getFailedPercentage() {
        return this.getFailedPercentageFormatted();
    }

    public String getFailedPercentageFormatted() {
        return this.results.isEmpty() || this.getFailed() == 0 ? ZERO_PERCENTAGE : this.getNewDecimalFormat().format((double)this.getFailed() / (double)(this.getFailed() + this.getSuccess()) * 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSkipped() {
        int count = 0;
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult testResult : this.results) {
                if (!testResult.isSkipped()) continue;
                ++count;
            }
        }
        return count;
    }

    @Deprecated
    public String getSkippedPercentage() {
        return this.getSkippedPercentageFormatted();
    }

    public String getSkippedPercentageFormatted() {
        return this.results.isEmpty() ? ZERO_PERCENTAGE : this.getNewDecimalFormat().format((double)this.getSkipped() / (double)this.results.size() * 100.0);
    }

    public int getSize() {
        return this.results.size();
    }

    public Duration getTotalDuration() {
        return Duration.ofMillis(this.results.stream().filter(r -> Objects.nonNull(r.getDuration())).mapToLong(r -> r.getDuration().toMillis()).sum());
    }

    private DecimalFormat getNewDecimalFormat() {
        DecimalFormatSymbols symbol = new DecimalFormatSymbols();
        symbol.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(ZERO_PERCENTAGE);
        decimalFormat.setDecimalFormatSymbols(symbol);
        return decimalFormat;
    }

    public static interface ResultCallback {
        public void doWithResult(TestResult var1);
    }
}

