/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.DefaultMessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmptyMessageValidator
extends DefaultMessageValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEmptyMessageValidator.class);

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) {
        if (controlMessage == null || controlMessage.getPayload() == null) {
            logger.debug("Skip message payload validation as no control message was defined");
            return;
        }
        if (!Optional.ofNullable(controlMessage.getPayload(String.class)).orElse("").isEmpty()) {
            throw new ValidationException("Empty message validation failed - control message is not empty!");
        }
        logger.debug("Start to verify empty message payload ...");
        if (!Optional.ofNullable(receivedMessage.getPayload(String.class)).orElse("").isEmpty()) {
            throw new ValidationException("Validation failed - received message content is not empty!");
        }
        logger.info("Message payload is empty as expected: All values OK");
    }
}

