/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.Optional;

public class TestActor {
    private static final String TEST_ACTOR_ENABLED_PROPERTY = "citrus.test.actor.%s.enabled";
    private static final String TEST_ACTOR_ENABLED_ENV = "CITRUS_TEST_ACTOR_%s_ENABLED";
    private String name;
    private boolean disabled = false;

    public TestActor() {
    }

    public TestActor(String name) {
        this.name = name;
    }

    public TestActor(String name, boolean disabled) {
        this.name = name;
        this.disabled = disabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDisabled() {
        boolean enabled = true;
        if (this.name != null && !this.name.isBlank()) {
            enabled = Boolean.parseBoolean(System.getProperty(TEST_ACTOR_ENABLED_PROPERTY.formatted(this.name.trim().toLowerCase()), Optional.ofNullable(System.getenv(TEST_ACTOR_ENABLED_ENV.formatted(this.name.trim().replaceAll("\\W", "_").toUpperCase()))).orElse("true")));
        }
        return !enabled || this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

