/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.context.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TypeAliasResolver<S, A> {
    public static final Logger logger = LoggerFactory.getLogger(TypeAliasResolver.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/context/resolver";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/context/resolver");
    public static final Map<String, TypeAliasResolver<?, ?>> resolvers = new HashMap();

    public static Map<String, TypeAliasResolver<?, ?>> lookup() {
        if (resolvers.isEmpty()) {
            resolvers.putAll(TYPE_RESOLVER.resolveAll("", "type", "name"));
            if (logger.isDebugEnabled()) {
                resolvers.forEach((k, v) -> logger.debug("Found type alias resolver '{}' as {}", k, v.getClass()));
            }
        }
        return resolvers;
    }

    public static Optional<TypeAliasResolver<?, ?>> lookup(String resolver) {
        try {
            return Optional.of((TypeAliasResolver)TYPE_RESOLVER.resolve(resolver, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve type alias resolver from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)resolver);
            return Optional.empty();
        }
    }

    public boolean isAliasFor(Class<?> var1);

    public S adapt(Object var1);

    public Class<A> getAliasType();
}

