/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.log;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.CitrusSettings;

public final class CitrusLogSettings {
    private static final String CITRUS_LOGGER_PROPERTY_PREFIX = "citrus.logger.";
    private static final String CITRUS_LOGGER_ENV_PREFIX = "CITRUS_LOG_";
    public static final String LOG_MASK_KEYWORDS_PROPERTY = "citrus.logger.mask.keywords";
    public static final String LOG_MASK_KEYWORDS_ENV = "CITRUS_LOG_MASK_KEYWORDS";
    public static final String LOG_MASK_KEYWORDS_DEFAULT = "password,secret,secretKey";
    public static final String LOG_MODIFIER_PROPERTY = "citrus.logger.modifier";
    public static final String LOG_MODIFIER_ENV = "CITRUS_LOG_MODIFIER";
    public static final String LOG_MODIFIER_DEFAULT = Boolean.TRUE.toString();
    public static final String LOG_MASK_VALUE_PROPERTY = "citrus.logger.mask.value";
    public static final String LOG_MASK_VALUE_ENV = "CITRUS_LOG_MASK_VALUE";
    public static final String LOG_MASK_VALUE_DEFAULT = "****";
    public static final String LOG_MASK_XML_PROPERTY = "citrus.logger.mask.xml";
    public static final String LOG_MASK_XML_ENV = "CITRUS_LOG_MASK_XML";
    public static final String LOG_MASK_XML_DEFAULT = Boolean.TRUE.toString();
    public static final String LOG_MASK_JSON_PROPERTY = "citrus.logger.mask.json";
    public static final String LOG_MASK_JSON_ENV = "CITRUS_LOG_MASK_JSON";
    public static final String LOG_MASK_JSON_DEFAULT = Boolean.TRUE.toString();
    public static final String LOG_MASK_YAML_PROPERTY = "citrus.logger.mask.yaml";
    public static final String LOG_MASK_YAML_ENV = "CITRUS_LOG_MASK_YAML";
    public static final String LOG_MASK_YAML_DEFAULT = Boolean.TRUE.toString();
    public static final String LOG_MASK_KEY_VALUE_PROPERTY = "citrus.logger.mask.key.value";
    public static final String LOG_MASK_KEY_VALUE_ENV = "CITRUS_LOG_MASK_KEY_VALUE";
    public static final String LOG_MASK_KEY_VALUE_DEFAULT = Boolean.TRUE.toString();
    public static final String LOG_MASK_FORM_URL_ENCODED_PROPERTY = "citrus.logger.mask.form.url.encoded";
    public static final String LOG_MASK_FORM_URL_ENCODED_ENV = "CITRUS_LOG_MASK_FORM_URL_ENCODED";
    public static final String LOG_MASK_FORM_URL_ENCODED_DEFAULT = Boolean.TRUE.toString();

    private CitrusLogSettings() {
    }

    public static Set<String> getLogMaskKeywords() {
        return Stream.of(CitrusSettings.getPropertyEnvOrDefault(LOG_MASK_KEYWORDS_PROPERTY, LOG_MASK_KEYWORDS_ENV, LOG_MASK_KEYWORDS_DEFAULT).split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public static boolean isLogModifierEnabled() {
        return Boolean.parseBoolean(CitrusSettings.getPropertyEnvOrDefault(LOG_MODIFIER_PROPERTY, LOG_MODIFIER_ENV, LOG_MODIFIER_DEFAULT));
    }

    public static String getLogMaskValue() {
        return CitrusSettings.getPropertyEnvOrDefault(LOG_MASK_VALUE_PROPERTY, LOG_MASK_VALUE_ENV, LOG_MASK_VALUE_DEFAULT);
    }

    public static boolean isMaskXmlEnabled() {
        return Boolean.parseBoolean(CitrusSettings.getPropertyEnvOrDefault(LOG_MASK_XML_PROPERTY, LOG_MASK_XML_ENV, LOG_MASK_XML_DEFAULT));
    }

    public static boolean isMaskJsonEnabled() {
        return Boolean.parseBoolean(CitrusSettings.getPropertyEnvOrDefault(LOG_MASK_JSON_PROPERTY, LOG_MASK_JSON_ENV, LOG_MASK_JSON_DEFAULT));
    }

    public static boolean isMaskYamlEnabled() {
        return Boolean.parseBoolean(CitrusSettings.getPropertyEnvOrDefault(LOG_MASK_YAML_PROPERTY, LOG_MASK_YAML_ENV, LOG_MASK_YAML_DEFAULT));
    }

    public static boolean isMaskKeyValueEnabled() {
        return Boolean.parseBoolean(CitrusSettings.getPropertyEnvOrDefault(LOG_MASK_KEY_VALUE_PROPERTY, LOG_MASK_KEY_VALUE_ENV, LOG_MASK_KEY_VALUE_DEFAULT));
    }

    public static boolean isMaskFormUrlEncodedEnabled() {
        return Boolean.parseBoolean(CitrusSettings.getPropertyEnvOrDefault(LOG_MASK_FORM_URL_ENCODED_PROPERTY, LOG_MASK_FORM_URL_ENCODED_ENV, LOG_MASK_FORM_URL_ENCODED_DEFAULT));
    }
}

