/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageTransformer;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface MessageProcessor
extends MessageTransformer {
    public static final Logger logger = LoggerFactory.getLogger(MessageProcessor.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/processor";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/processor");

    public static <T extends MessageProcessor, B extends Builder<T, B>> Optional<Builder<T, B>> lookup(String processor, Object ... args) {
        try {
            Builder instance = (Builder)TYPE_RESOLVER.resolve(processor, args);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve message processor from resource '{}/{}' - caused by: {}", new Object[]{RESOURCE_PATH, processor, e.getMessage()});
            return Optional.empty();
        }
    }

    public void process(Message var1, TestContext var2);

    @Override
    default public Message transform(Message message, TestContext context) {
        this.process(message, context);
        return message;
    }

    public static interface Builder<T extends MessageProcessor, B extends Builder<T, B>> {
        public T build();
    }
}

