/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestCase;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestListenerAware;

public class TestListeners
implements TestListenerAware {
    private final List<TestListener> testListeners = new ArrayList<TestListener>();

    public void onTestFailure(TestCase test, Throwable cause) {
        for (TestListener listener : this.testListeners) {
            listener.onTestFailure(test, cause);
        }
    }

    @Deprecated(forRemoval=true)
    public void onTestFinish(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestFinish(test);
        }
    }

    public void onTestExecutionStart(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestExecutionStart(test);
        }
    }

    public void onTestExecutionEnd(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestExecutionEnd(test);
        }
    }

    public void onTestSkipped(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestSkipped(test);
        }
    }

    public void onTestStart(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestStart(test);
        }
    }

    public void onTestFinalization(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestEnd(test);
        }
    }

    public void onFinalActionsStart(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onFinalActionsStart(test);
        }
    }

    public void onFinalActionsEnd(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onFinalActionsEnd(test);
        }
    }

    public void onBeforeTestEnd(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onBeforeTestEnd(test);
        }
    }

    public void onAfterTestEnd(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onAfterTestEnd(test);
        }
    }

    public void onBeforeTestStart(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onBeforeTestStart(test);
        }
    }

    public void onAfterTestStart(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onAfterTestStart(test);
        }
    }

    public void onTestSuccess(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestSuccess(test);
        }
    }

    @Override
    public void addTestListener(TestListener listener) {
        if (!this.testListeners.contains(listener)) {
            this.testListeners.add(listener);
        }
    }

    public List<TestListener> getTestListeners() {
        return this.testListeners;
    }
}

