/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.citrusframework.validation.context.SchemaValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchemaValidator<T extends SchemaValidationContext> {
    public static final Logger logger = LoggerFactory.getLogger(SchemaValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/schemaValidator";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/schemaValidator");

    public static Map<String, SchemaValidator<? extends SchemaValidationContext>> lookup() {
        Map<String, SchemaValidator<? extends SchemaValidationContext>> validators = TYPE_RESOLVER.resolveAll("", "type", "name");
        if (logger.isDebugEnabled()) {
            validators.forEach((k, v) -> logger.debug("Found message validator '{}' as {}", k, v.getClass()));
        }
        return validators;
    }

    public static Optional<SchemaValidator<? extends SchemaValidationContext>> lookup(String validator) {
        try {
            SchemaValidator instance = (SchemaValidator)TYPE_RESOLVER.resolve(validator, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve validator from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)validator);
            return Optional.empty();
        }
    }

    public void validate(Message var1, TestContext var2, T var3);

    public boolean supportsMessageType(String var1, Message var2);

    public boolean canValidate(Message var1, boolean var2);

    public void validate(Message var1, TestContext var2, String var3, String var4);
}

