/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import org.citrusframework.TestSource;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class TestClass
extends TestSource {
    private final String method;
    private final Class<?> testClass;

    public TestClass(Class<?> testClass) {
        this(testClass, null);
    }

    public TestClass(Class<?> testClass, String method) {
        super(testClass);
        this.testClass = testClass;
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public static TestClass fromString(String testClass) {
        try {
            String className;
            String methodName = null;
            if (testClass.contains("#")) {
                className = testClass.substring(0, testClass.indexOf("#"));
                methodName = testClass.substring(testClass.indexOf("#") + 1);
            } else {
                className = testClass;
            }
            if (methodName != null && !methodName.isBlank()) {
                return new TestClass(Class.forName(className), methodName);
            }
            return new TestClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new CitrusRuntimeException("Failed to create test class", e);
        }
    }

    public static boolean isKnownToClasspath(String testClass) {
        try {
            String className = testClass.contains("#") ? testClass.substring(0, testClass.indexOf("#")) : testClass;
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

