/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions.selenium;

import org.citrusframework.actions.selenium.WebPage;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;

@FunctionalInterface
public interface PageValidator<T extends WebPage, B extends Endpoint> {
    public void validate(T var1, B var2, TestContext var3);

    default public void adaptAndValidate(WebPage webPage, Endpoint endpoint, TestContext context) {
        Endpoint browser;
        WebPage page;
        try {
            page = webPage;
        }
        catch (ClassCastException e) {
            throw new CitrusRuntimeException("Page validation failed, provided page '%s' is not of required type".formatted(webPage.getClass().getName()), e);
        }
        try {
            browser = endpoint;
        }
        catch (ClassCastException e) {
            throw new CitrusRuntimeException("Page validation failed, provided endpoint '%s' is not of required type".formatted(endpoint.getClass().getName()), e);
        }
        this.validate(page, browser, context);
    }
}

