/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface MessageSelector {
    public static final Logger logger = LoggerFactory.getLogger(MessageSelector.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/selector";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/selector");
    public static final Map<String, MessageSelectorFactory> factories = new ConcurrentHashMap<String, MessageSelectorFactory>();

    public static Map<String, MessageSelectorFactory> lookup() {
        if (factories.isEmpty()) {
            factories.putAll(TYPE_RESOLVER.resolveAll());
            if (logger.isDebugEnabled()) {
                factories.forEach((k, v) -> logger.debug("Found message selector '{}' as {}", k, v.getClass()));
            }
        }
        return factories;
    }

    public boolean accept(Message var1);

    public static interface MessageSelectorFactory {
        public boolean supports(String var1);

        public MessageSelector create(String var1, String var2, TestContext var3);
    }

    public static final class AllAcceptingMessageSelector
    implements MessageSelector {
        @Override
        public boolean accept(Message message) {
            return true;
        }
    }
}

