/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.ObjectHelper;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static void doWithClasses(Class<?> clazz, ClassCallback cc) throws IllegalArgumentException {
        Class<?>[] classes;
        for (Class<?> aClazz : classes = clazz.getDeclaredClasses()) {
            try {
                cc.doWith(aClazz);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access class '" + aClazz.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) throws IllegalArgumentException {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) throws IllegalArgumentException {
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null) {
            ReflectionHelper.doWithMethods(clazz.getSuperclass(), mc);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionHelper.doWithMethods(genericDeclaration, mc);
            }
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        ObjectHelper.assertNotNull(clazz, "Class must not be null");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        ObjectHelper.assertNotNull(clazz, "Class must not be null");
        ObjectHelper.assertNotNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CitrusRuntimeException) {
                CitrusRuntimeException runtimeException = (CitrusRuntimeException)throwable;
                throw runtimeException;
            }
            throw new CitrusRuntimeException("Failed to invoke method", e);
        }
    }

    public static void setField(Field f, Object instance, Object value) {
        try {
            if (!Modifier.isPublic(f.getModifiers()) && !f.canAccess(instance)) {
                f.setAccessible(true);
            }
            f.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Cannot set value of type: " + value.getClass() + " into field: " + f, e);
        }
    }

    public static Object getField(Field f, Object instance) {
        try {
            if ((!Modifier.isPublic(f.getModifiers()) || !Modifier.isPublic(f.getDeclaringClass().getModifiers()) || Modifier.isFinal(f.getModifiers())) && (Modifier.isStatic(f.getModifiers()) ? !f.canAccess(null) : !f.canAccess(instance))) {
                f.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return f.get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void copyFields(@Nonnull Class<?> clazz, @Nonnull Object source, @Nonnull Object target) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    field.set(target, field.get(source));
                }
                catch (IllegalAccessException e) {
                    throw new CitrusRuntimeException(String.format("Unable to reflectively copy fields from source to target. clazz=%s sourceClass=%s targetClass=%s", clazz, source.getClass(), target.getClass()));
                }
            }
        }
    }

    @FunctionalInterface
    public static interface ClassCallback {
        public void doWith(Class<?> var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

