/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.container.AbstractActionContainer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractSuiteActionContainer
extends AbstractActionContainer {
    private List<String> suiteNames = new ArrayList<String>();
    private List<String> testGroups = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private Map<String, String> systemProperties = new HashMap<String, String>();

    public boolean shouldExecute(String suiteName, String[] includedGroups) {
        String baseErrorMessage = "Skip before/after suite container because of %s restriction - do not execute container '%s'";
        if (StringUtils.hasText((String)suiteName) && !CollectionUtils.isEmpty(this.suiteNames) && !this.suiteNames.contains(suiteName)) {
            this.log.warn(String.format(baseErrorMessage, "suite name", this.getName()));
            return false;
        }
        if (!this.checkTestGroups(includedGroups)) {
            this.log.warn(String.format(baseErrorMessage, "test groups", this.getName()));
            return false;
        }
        for (Map.Entry<String, String> envEntry : this.env.entrySet()) {
            if (System.getenv().containsKey(envEntry.getKey()) && (!StringUtils.hasText((String)envEntry.getValue()) || System.getenv().get(envEntry.getKey()).equals(envEntry.getValue()))) continue;
            this.log.warn(String.format(baseErrorMessage, "env properties", this.getName()));
            return false;
        }
        for (Map.Entry<String, String> systemProperty : this.systemProperties.entrySet()) {
            if (System.getProperties().containsKey(systemProperty.getKey()) && (!StringUtils.hasText((String)systemProperty.getValue()) || System.getProperties().get(systemProperty.getKey()).equals(systemProperty.getValue()))) continue;
            this.log.warn(String.format(baseErrorMessage, "system properties", this.getName()));
            return false;
        }
        return true;
    }

    private boolean checkTestGroups(String[] includedGroups) {
        if (this.testGroups.isEmpty()) {
            return true;
        }
        if (includedGroups != null) {
            for (String includedGroup : includedGroups) {
                if (!this.testGroups.contains(includedGroup)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTestGroups() {
        return this.testGroups;
    }

    public void setTestGroups(List<String> testGroups) {
        this.testGroups = testGroups;
    }

    public List<String> getSuiteNames() {
        return this.suiteNames;
    }

    public void setSuiteNames(List<String> suiteNames) {
        this.suiteNames = suiteNames;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }
}

