/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.citrusframework.TestResult;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.report.AbstractTestReporter;
import org.citrusframework.report.JUnitReporterSettings;
import org.citrusframework.report.TestResults;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JUnitReporter
extends AbstractTestReporter {
    private static Logger log = LoggerFactory.getLogger(JUnitReporter.class);
    private String outputDirectory = JUnitReporterSettings.getReportDirectory();
    private String reportFileNamePattern = JUnitReporterSettings.getReportFilePattern();
    private String suiteName = JUnitReporterSettings.getSuiteName();
    private String reportTemplate = JUnitReporterSettings.getReportTemplate();
    private String successTemplate = JUnitReporterSettings.getSuccessTemplate();
    private String failedTemplate = JUnitReporterSettings.getFailedTemplate();
    private boolean enabled = JUnitReporterSettings.isReportEnabled();

    @Override
    public void generate(TestResults testResults) {
        if (this.isEnabled()) {
            ReportTemplates reportTemplates = new ReportTemplates();
            log.debug("Generating JUnit test report");
            try {
                List results = testResults.asList();
                this.createReportFile(String.format(this.reportFileNamePattern, this.suiteName), this.createReportContent(this.suiteName, results, reportTemplates), new File(this.getReportDirectory()));
                HashMap groupedResults = new HashMap();
                for (TestResult result : results) {
                    if (!groupedResults.containsKey(result.getClassName())) {
                        groupedResults.put(result.getClassName(), new ArrayList());
                    }
                    ((List)groupedResults.get(result.getClassName())).add(result);
                }
                File targetDirectory = new File(this.getReportDirectory() + (String)(StringUtils.hasText((String)this.outputDirectory) ? File.separator + this.outputDirectory : ""));
                for (Map.Entry resultEntry : groupedResults.entrySet()) {
                    this.createReportFile(String.format(this.reportFileNamePattern, resultEntry.getKey()), this.createReportContent((String)resultEntry.getKey(), (List)resultEntry.getValue(), reportTemplates), targetDirectory);
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to generate JUnit test report", (Throwable)e);
            }
        }
    }

    private String createReportContent(String suiteName, List<TestResult> results, ReportTemplates templates) throws IOException {
        StringBuilder reportDetails = new StringBuilder();
        for (TestResult result : results) {
            Properties detailProps = new Properties();
            detailProps.put("test.class", result.getClassName());
            detailProps.put("test.name", StringEscapeUtils.escapeXml((String)result.getTestName()));
            detailProps.put("test.duration", "0.0");
            if (result.isFailed()) {
                detailProps.put("test.error.cause", Optional.ofNullable(result.getCause()).map(Object::getClass).map(Class::getName).orElse(Objects.toString(result.getFailureType(), "")));
                detailProps.put("test.error.msg", StringEscapeUtils.escapeXml((String)result.getErrorMessage()));
                detailProps.put("test.error.stackTrace", Optional.ofNullable(result.getCause()).map(cause -> {
                    StringWriter writer = new StringWriter();
                    cause.printStackTrace(new PrintWriter(writer));
                    return writer.toString();
                }).orElse(Objects.toString(result.getFailureType(), "")));
                reportDetails.append(System.lineSeparator()).append("    ").append(PropertyUtils.replacePropertiesInString(templates.getFailedTemplate(), detailProps));
                continue;
            }
            reportDetails.append(System.lineSeparator()).append("    ").append(PropertyUtils.replacePropertiesInString(templates.getSuccessTemplate(), detailProps));
        }
        Properties reportProps = new Properties();
        reportProps.put("test.suite", suiteName);
        reportProps.put("test.cnt", Integer.toString(results.size()));
        reportProps.put("test.skipped.cnt", Long.toString(results.stream().filter(TestResult::isSkipped).count()));
        reportProps.put("test.failed.cnt", Long.toString(results.stream().filter(TestResult::isFailed).count()));
        reportProps.put("test.success.cnt", Long.toString(results.stream().filter(TestResult::isSuccess).count()));
        reportProps.put("test.error.cnt", "0");
        reportProps.put("test.duration", "0.0");
        reportProps.put("tests", reportDetails.toString());
        return PropertyUtils.replacePropertiesInString(templates.getReportTemplate(), reportProps);
    }

    private void createReportFile(String reportFileName, String content, File targetDirectory) {
        if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create report output directory: " + this.getReportDirectory() + (String)(StringUtils.hasText((String)this.outputDirectory) ? "/" + this.outputDirectory : ""));
        }
        try (FileWriter fileWriter = new FileWriter(new File(targetDirectory, reportFileName));){
            ((Writer)fileWriter).append(content);
            ((Writer)fileWriter).flush();
        }
        catch (IOException e) {
            log.error("Failed to create test report", (Throwable)e);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getReportFileNamePattern() {
        return this.reportFileNamePattern;
    }

    public void setReportFileNamePattern(String reportFileNamePattern) {
        this.reportFileNamePattern = reportFileNamePattern;
    }

    public String getReportTemplate() {
        return this.reportTemplate;
    }

    public void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getSuccessTemplate() {
        return this.successTemplate;
    }

    public void setSuccessTemplate(String successTemplate) {
        this.successTemplate = successTemplate;
    }

    public String getFailedTemplate() {
        return this.failedTemplate;
    }

    public void setFailedTemplate(String failedTemplate) {
        this.failedTemplate = failedTemplate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private class ReportTemplates {
        private String reportTemplateContent;
        private String successTemplateContent;
        private String failedTemplateContent;

        private ReportTemplates() {
        }

        public String getReportTemplate() throws IOException {
            if (this.reportTemplateContent == null) {
                this.reportTemplateContent = FileUtils.readToString(FileUtils.getFileResource(JUnitReporter.this.reportTemplate)).trim();
            }
            return this.reportTemplateContent;
        }

        public String getSuccessTemplate() throws IOException {
            if (this.successTemplateContent == null) {
                this.successTemplateContent = FileUtils.readToString(FileUtils.getFileResource(JUnitReporter.this.successTemplate)).trim();
            }
            return this.successTemplateContent;
        }

        public String getFailedTemplate() throws IOException {
            if (this.failedTemplateContent == null) {
                this.failedTemplateContent = FileUtils.readToString(FileUtils.getFileResource(JUnitReporter.this.failedTemplate)).trim();
            }
            return this.failedTemplateContent;
        }
    }
}

