/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.AbstractAsyncTestAction;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async
extends AbstractActionContainer {
    private static final Logger LOG = LoggerFactory.getLogger(Async.class);
    private final List<TestActionBuilder<?>> errorActions;
    private final List<TestActionBuilder<?>> successActions;

    public Async(Builder builder) {
        super("async", builder);
        this.successActions = builder.successActions;
        this.errorActions = builder.errorActions;
    }

    @Override
    public void doExecute(TestContext context) {
        LOG.debug("Async container forking action execution ...");
        AbstractAsyncTestAction asyncTestAction = new AbstractAsyncTestAction(){

            @Override
            public void doExecuteAsync(TestContext context) {
                for (TestActionBuilder actionBuilder : Async.this.actions) {
                    Async.this.executeAction(actionBuilder.build(), context);
                }
            }

            @Override
            public void onError(TestContext context, Throwable error) {
                LOG.info("Apply error actions after async container ...");
                for (TestActionBuilder<?> actionBuilder : Async.this.errorActions) {
                    TestAction action = actionBuilder.build();
                    action.execute(context);
                }
            }

            @Override
            public void onSuccess(TestContext context) {
                LOG.info("Apply success actions after async container ...");
                for (TestActionBuilder<?> actionBuilder : Async.this.successActions) {
                    TestAction action = actionBuilder.build();
                    action.execute(context);
                }
            }
        };
        this.executeAction(asyncTestAction, context);
    }

    public List<TestAction> getSuccessActions() {
        return this.successActions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public List<TestAction> getErrorActions() {
        return this.errorActions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractTestContainerBuilder<Async, Builder> {
        private final List<TestActionBuilder<?>> errorActions = new ArrayList();
        private final List<TestActionBuilder<?>> successActions = new ArrayList();

        public static Builder async() {
            return new Builder();
        }

        public Builder errorAction(TestAction action) {
            this.errorActions.add(() -> action);
            return this;
        }

        public Builder successAction(TestAction action) {
            this.successActions.add(() -> action);
            return this;
        }

        public Builder errorAction(TestActionBuilder<?> action) {
            this.errorActions.add(action);
            return this;
        }

        public Builder successAction(TestActionBuilder<?> action) {
            this.successActions.add(action);
            return this;
        }

        public Builder errorActions(TestActionBuilder<?> ... actions) {
            this.errorActions.addAll(Arrays.asList(actions));
            return this;
        }

        public Builder successActions(TestActionBuilder<?> ... actions) {
            this.successActions.addAll(Arrays.asList(actions));
            return this;
        }

        public Builder errorActions(TestAction ... actions) {
            Stream.of(actions).map(action -> () -> action).forEach(this::errorAction);
            return this;
        }

        public Builder successActions(TestAction ... actions) {
            Stream.of(actions).map(action -> () -> action).forEach(this::successAction);
            return this;
        }

        @Override
        public Async build() {
            return this.doBuild();
        }

        @Override
        protected Async doBuild() {
            return new Async(this);
        }
    }
}

