/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.Collection;
import org.citrusframework.AbstractTestBoundaryContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractTestBoundaryActionContainer;
import org.citrusframework.container.AfterTest;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SequenceAfterTest
extends AbstractTestBoundaryActionContainer
implements AfterTest {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceAfterTest.class);

    @Override
    public void doExecute(TestContext context) {
        if (CollectionUtils.isEmpty((Collection)this.actions)) {
            return;
        }
        LOG.info("Entering after test block");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + this.actions.size() + " actions after test");
            LOG.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            action.execute(context);
        }
    }

    public static class Builder
    extends AbstractTestBoundaryContainerBuilder<SequenceAfterTest, Builder> {
        public static Builder afterTest() {
            return new Builder();
        }

        @Override
        public SequenceAfterTest doBuild() {
            return new SequenceAfterTest();
        }
    }
}

