/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions;

import org.citrusframework.functions.Function;
import org.citrusframework.functions.FunctionLibrary;
import org.citrusframework.functions.core.AbsoluteFunction;
import org.citrusframework.functions.core.AvgFunction;
import org.citrusframework.functions.core.CeilingFunction;
import org.citrusframework.functions.core.ChangeDateFunction;
import org.citrusframework.functions.core.ConcatFunction;
import org.citrusframework.functions.core.CurrentDateFunction;
import org.citrusframework.functions.core.DecodeBase64Function;
import org.citrusframework.functions.core.DigestAuthHeaderFunction;
import org.citrusframework.functions.core.EncodeBase64Function;
import org.citrusframework.functions.core.FloorFunction;
import org.citrusframework.functions.core.LoadMessageFunction;
import org.citrusframework.functions.core.LocalHostAddressFunction;
import org.citrusframework.functions.core.LowerCaseFunction;
import org.citrusframework.functions.core.MaxFunction;
import org.citrusframework.functions.core.MinFunction;
import org.citrusframework.functions.core.RandomEnumValueFunction;
import org.citrusframework.functions.core.RandomNumberFunction;
import org.citrusframework.functions.core.RandomStringFunction;
import org.citrusframework.functions.core.RandomUUIDFunction;
import org.citrusframework.functions.core.ReadFileResourceFunction;
import org.citrusframework.functions.core.RoundFunction;
import org.citrusframework.functions.core.StringLengthFunction;
import org.citrusframework.functions.core.SubstringAfterFunction;
import org.citrusframework.functions.core.SubstringBeforeFunction;
import org.citrusframework.functions.core.SubstringFunction;
import org.citrusframework.functions.core.SumFunction;
import org.citrusframework.functions.core.SystemPropertyFunction;
import org.citrusframework.functions.core.TranslateFunction;
import org.citrusframework.functions.core.UnixTimestampFunction;
import org.citrusframework.functions.core.UpperCaseFunction;
import org.citrusframework.functions.core.UrlDecodeFunction;
import org.citrusframework.functions.core.UrlEncodeFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFunctionLibrary
extends FunctionLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFunctionLibrary.class);

    public DefaultFunctionLibrary() {
        this.setName("citrusFunctionLibrary");
        this.getMembers().put("randomNumber", new RandomNumberFunction());
        this.getMembers().put("randomString", new RandomStringFunction());
        this.getMembers().put("concat", new ConcatFunction());
        this.getMembers().put("currentDate", new CurrentDateFunction());
        this.getMembers().put("substring", new SubstringFunction());
        this.getMembers().put("stringLength", new StringLengthFunction());
        this.getMembers().put("translate", new TranslateFunction());
        this.getMembers().put("substringBefore", new SubstringBeforeFunction());
        this.getMembers().put("substringAfter", new SubstringAfterFunction());
        this.getMembers().put("round", new RoundFunction());
        this.getMembers().put("floor", new FloorFunction());
        this.getMembers().put("ceiling", new CeilingFunction());
        this.getMembers().put("upperCase", new UpperCaseFunction());
        this.getMembers().put("lowerCase", new LowerCaseFunction());
        this.getMembers().put("average", new AvgFunction());
        this.getMembers().put("minimum", new MinFunction());
        this.getMembers().put("maximum", new MaxFunction());
        this.getMembers().put("sum", new SumFunction());
        this.getMembers().put("absolute", new AbsoluteFunction());
        this.getMembers().put("randomEnumValue", new RandomEnumValueFunction());
        this.getMembers().put("randomUUID", new RandomUUIDFunction());
        this.getMembers().put("encodeBase64", new EncodeBase64Function());
        this.getMembers().put("decodeBase64", new DecodeBase64Function());
        this.getMembers().put("urlEncode", new UrlEncodeFunction());
        this.getMembers().put("urlDecode", new UrlDecodeFunction());
        this.getMembers().put("digestAuthHeader", new DigestAuthHeaderFunction());
        this.getMembers().put("localHostAddress", new LocalHostAddressFunction());
        this.getMembers().put("changeDate", new ChangeDateFunction());
        this.getMembers().put("readFile", new ReadFileResourceFunction());
        this.getMembers().put("message", new LoadMessageFunction());
        this.getMembers().put("systemProperty", new SystemPropertyFunction());
        this.getMembers().put("unixTimestamp", new UnixTimestampFunction());
        this.lookupFunctions();
    }

    private void lookupFunctions() {
        Function.lookup().forEach((k, m) -> {
            this.getMembers().put(k, m);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Register function '%s' as %s", k, m.getClass()));
            }
        });
    }
}

