/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.util.FileUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;

public class ReadFileResourceFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Missing file path function parameter");
        }
        boolean base64 = parameterList.size() > 1 && Boolean.parseBoolean(parameterList.get(1));
        try {
            if (base64) {
                if (parameterList.size() > 2 && Boolean.parseBoolean(parameterList.get(2))) {
                    return Base64.encodeBase64String((byte[])this.readFileContent(parameterList.get(0), context, true).getBytes(FileUtils.getCharset(parameterList.get(0))));
                }
                return Base64.encodeBase64String((byte[])FileCopyUtils.copyToByteArray((InputStream)FileUtils.getFileResource(parameterList.get(0), context).getInputStream()));
            }
            return this.readFileContent(parameterList.get(0), context, true);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read file", (Throwable)e);
        }
    }

    private String readFileContent(String filePath, TestContext context, boolean replace) throws IOException {
        String content = FileUtils.readToString(FileUtils.getFileResource(filePath, context), FileUtils.getCharset(filePath));
        return replace ? context.replaceDynamicContentInString(content) : content;
    }
}

