/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main.scan;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.citrusframework.TestClass;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.scan.AbstractTestScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ClassPathTestScanner
extends AbstractTestScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathTestScanner.class);
    private final Class<? extends Annotation> annotationType;

    public ClassPathTestScanner(Class<? extends Annotation> annotationType, String ... includes) {
        super(includes);
        this.annotationType = annotationType;
    }

    public List<TestClass> findTestsInPackage(String packageName) {
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/**/*.class";
            Resource[] resources = resolver.getResources(packageSearchPath);
            ArrayList<String> classes = new ArrayList<String>();
            for (Resource resource : resources) {
                MetadataReader metadataReader;
                if (!resource.isReadable() || !this.isIncluded((metadataReader = new SimpleMetadataReaderFactory().getMetadataReader(resource)).getClassMetadata())) continue;
                classes.add(metadataReader.getClassMetadata().getClassName());
            }
            return classes.stream().distinct().map(TestClass::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to scan classpath package '%s'", packageName), (Throwable)e);
        }
    }

    protected boolean isIncluded(ClassMetadata metadata) {
        if (!this.isIncluded(metadata.getClassName())) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(metadata.getClassName());
            if (clazz.isAnnotationPresent(this.annotationType)) {
                return true;
            }
            AtomicBoolean hasTestMethod = new AtomicBoolean(false);
            ReflectionUtils.doWithMethods(clazz, method -> hasTestMethod.set(true), method -> AnnotationUtils.findAnnotation((Method)method, this.annotationType) != null);
            return hasTestMethod.get();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.warn("Unable to access class: " + metadata.getClassName());
            return false;
        }
    }
}

