/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.CitrusSettings;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.container.AfterSuite;
import org.citrusframework.container.BeforeSuite;
import org.citrusframework.context.TestContext;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.endpoint.DefaultEndpointFactory;
import org.citrusframework.endpoint.EndpointFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.functions.DefaultFunctionRegistry;
import org.citrusframework.functions.FunctionRegistry;
import org.citrusframework.log.DefaultLogModifier;
import org.citrusframework.log.LogModifier;
import org.citrusframework.message.MessageProcessors;
import org.citrusframework.report.DefaultTestReporters;
import org.citrusframework.report.FailureStackTestListener;
import org.citrusframework.report.MessageListener;
import org.citrusframework.report.MessageListenerAware;
import org.citrusframework.report.MessageListeners;
import org.citrusframework.report.TestActionListener;
import org.citrusframework.report.TestActionListenerAware;
import org.citrusframework.report.TestActionListeners;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestListenerAware;
import org.citrusframework.report.TestListeners;
import org.citrusframework.report.TestReporter;
import org.citrusframework.report.TestReporterAware;
import org.citrusframework.report.TestReporters;
import org.citrusframework.report.TestResults;
import org.citrusframework.report.TestSuiteListener;
import org.citrusframework.report.TestSuiteListenerAware;
import org.citrusframework.report.TestSuiteListeners;
import org.citrusframework.spi.ReferenceRegistry;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.SimpleReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.TypeConverter;
import org.citrusframework.validation.DefaultMessageValidatorRegistry;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.MessageValidatorRegistry;
import org.citrusframework.validation.matcher.DefaultValidationMatcherRegistry;
import org.citrusframework.validation.matcher.ValidationMatcherRegistry;
import org.citrusframework.variable.GlobalVariables;
import org.citrusframework.xml.namespace.NamespaceContextBuilder;

public class CitrusContext
implements TestListenerAware,
TestActionListenerAware,
TestSuiteListenerAware,
TestReporterAware,
MessageListenerAware,
ReferenceRegistry {
    private final TestContextFactory testContextFactory;
    private final TestSuiteListeners testSuiteListeners;
    private final TestListeners testListeners;
    private final TestActionListeners testActionListeners;
    private final TestReporters testReporters;
    private final List<BeforeSuite> beforeSuite;
    private final List<AfterSuite> afterSuite;
    private final FunctionRegistry functionRegistry;
    private final ValidationMatcherRegistry validationMatcherRegistry;
    private final GlobalVariables globalVariables;
    private final MessageValidatorRegistry messageValidatorRegistry;
    private final MessageListeners messageListeners;
    private final EndpointFactory endpointFactory;
    private final ReferenceResolver referenceResolver;
    private final MessageProcessors messageProcessors;
    private final NamespaceContextBuilder namespaceContextBuilder;
    private final TypeConverter typeConverter;
    private final LogModifier logModifier;

    protected CitrusContext(Builder builder) {
        this.testSuiteListeners = builder.testSuiteListeners;
        this.testListeners = builder.testListeners;
        this.testActionListeners = builder.testActionListeners;
        this.testReporters = builder.testReporters;
        this.beforeSuite = builder.beforeSuite;
        this.afterSuite = builder.afterSuite;
        this.functionRegistry = builder.functionRegistry;
        this.validationMatcherRegistry = builder.validationMatcherRegistry;
        this.globalVariables = builder.globalVariables;
        this.messageValidatorRegistry = builder.messageValidatorRegistry;
        this.messageListeners = builder.messageListeners;
        this.endpointFactory = builder.endpointFactory;
        this.referenceResolver = builder.referenceResolver;
        this.messageProcessors = builder.messageProcessors;
        this.namespaceContextBuilder = builder.namespaceContextBuilder;
        this.typeConverter = builder.typeConverter;
        this.logModifier = builder.logModifier;
        this.testContextFactory = builder.testContextFactory;
    }

    public static CitrusContext create() {
        CitrusContext context = Builder.defaultContext().build();
        if (StringUtils.hasText(CitrusSettings.DEFAULT_CONFIG_CLASS)) {
            try {
                Class<?> configClass = Class.forName(CitrusSettings.DEFAULT_CONFIG_CLASS);
                context.parseConfiguration(configClass);
            }
            catch (ClassNotFoundException e) {
                throw new CitrusRuntimeException("Failed to instantiate custom configuration class", (Throwable)e);
            }
        }
        return context;
    }

    public void parseConfiguration(Class<?> configClass) {
        CitrusAnnotations.parseConfiguration(configClass, this);
    }

    public void parseConfiguration(Object configuration) {
        CitrusAnnotations.parseConfiguration(configuration, this);
    }

    public TestContext createTestContext() {
        return this.testContextFactory.getObject();
    }

    public void addTestSuiteListener(TestSuiteListener suiteListener) {
        this.testSuiteListeners.addTestSuiteListener(suiteListener);
    }

    public void addTestListener(TestListener testListener) {
        this.testListeners.addTestListener(testListener);
    }

    public void addTestActionListener(TestActionListener testActionListener) {
        this.testActionListeners.addTestActionListener(testActionListener);
    }

    public void addTestReporter(TestReporter testReporter) {
        this.testReporters.addTestReporter(testReporter);
    }

    public void addMessageListener(MessageListener listener) {
        this.messageListeners.addMessageListener(listener);
    }

    public void close() {
    }

    public List<AfterSuite> getAfterSuite() {
        return this.afterSuite;
    }

    public List<BeforeSuite> getBeforeSuite() {
        return this.beforeSuite;
    }

    public TestListeners getTestListeners() {
        return this.testListeners;
    }

    public TestActionListeners getTestActionListeners() {
        return this.testActionListeners;
    }

    public TestSuiteListeners getTestSuiteListeners() {
        return this.testSuiteListeners;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.validationMatcherRegistry;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.messageValidatorRegistry;
    }

    public MessageListeners getMessageListeners() {
        return this.messageListeners;
    }

    public EndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public MessageProcessors getMessageProcessors() {
        return this.messageProcessors;
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public LogModifier getLogModifier() {
        return this.logModifier;
    }

    public TestContextFactory getTestContextFactory() {
        return this.testContextFactory;
    }

    public void bind(String name, Object value) {
        if (this.referenceResolver != null) {
            this.referenceResolver.bind(name, value);
            if (value instanceof MessageValidator) {
                this.getMessageValidatorRegistry().addMessageValidator(name, (MessageValidator)value);
            }
        }
    }

    public TestResults getTestResults() {
        return this.testReporters.getTestResults();
    }

    public void handleTestResults(TestResults testResults) {
        if (!this.getTestResults().equals(testResults)) {
            testResults.doWithResults(result -> this.getTestResults().addResult(result));
        }
    }

    public static class Builder {
        private TestContextFactory testContextFactory;
        private TestSuiteListeners testSuiteListeners = new TestSuiteListeners();
        private TestListeners testListeners = new TestListeners();
        private TestActionListeners testActionListeners = new TestActionListeners();
        private TestReporters testReporters = new DefaultTestReporters();
        private final List<BeforeSuite> beforeSuite = new ArrayList<BeforeSuite>();
        private final List<AfterSuite> afterSuite = new ArrayList<AfterSuite>();
        private FunctionRegistry functionRegistry = new DefaultFunctionRegistry();
        private ValidationMatcherRegistry validationMatcherRegistry = new DefaultValidationMatcherRegistry();
        private GlobalVariables globalVariables = new GlobalVariables();
        private MessageValidatorRegistry messageValidatorRegistry = new DefaultMessageValidatorRegistry();
        private MessageListeners messageListeners = new MessageListeners();
        private EndpointFactory endpointFactory = new DefaultEndpointFactory();
        private ReferenceResolver referenceResolver = new SimpleReferenceResolver();
        private MessageProcessors messageProcessors = new MessageProcessors();
        private NamespaceContextBuilder namespaceContextBuilder = new NamespaceContextBuilder();
        private TypeConverter typeConverter = TypeConverter.lookupDefault();
        private LogModifier logModifier = new DefaultLogModifier();

        public static Builder defaultContext() {
            Builder builder = new Builder();
            builder.testReporters.getTestReporters().stream().filter(TestSuiteListener.class::isInstance).map(TestSuiteListener.class::cast).forEach(builder::testSuiteListener);
            builder.testSuiteListener((TestSuiteListener)builder.testReporters);
            builder.testReporters.getTestReporters().stream().filter(TestListener.class::isInstance).map(TestListener.class::cast).forEach(builder::testListener);
            builder.testListener((TestListener)builder.testReporters);
            builder.testListener(new FailureStackTestListener());
            builder.testReporters.getTestReporters().stream().filter(TestActionListener.class::isInstance).map(TestActionListener.class::cast).forEach(builder::testActionListener);
            builder.testReporters.getTestReporters().stream().filter(MessageListener.class::isInstance).map(MessageListener.class::cast).forEach(builder::messageListener);
            return builder;
        }

        public Builder testContextFactory(TestContextFactory testContextFactory) {
            this.testContextFactory = testContextFactory;
            return this;
        }

        public Builder testSuiteListeners(TestSuiteListeners testSuiteListeners) {
            this.testSuiteListeners = testSuiteListeners;
            return this;
        }

        public Builder testSuiteListener(TestSuiteListener testSuiteListener) {
            this.testSuiteListeners.addTestSuiteListener(testSuiteListener);
            return this;
        }

        public Builder testListeners(TestListeners testListeners) {
            this.testListeners = testListeners;
            return this;
        }

        public Builder testListener(TestListener testListener) {
            this.testListeners.addTestListener(testListener);
            return this;
        }

        public Builder testActionListeners(TestActionListeners testActionListeners) {
            this.testActionListeners = testActionListeners;
            return this;
        }

        public Builder testActionListener(TestActionListener testActionListener) {
            this.testActionListeners.addTestActionListener(testActionListener);
            return this;
        }

        public Builder testReporters(TestReporters testReporters) {
            this.testReporters = testReporters;
            return this;
        }

        public Builder testReporter(TestReporter testReporter) {
            this.testReporters.addTestReporter(testReporter);
            return this;
        }

        public Builder beforeSuite(List<BeforeSuite> beforeSuite) {
            this.beforeSuite.addAll(beforeSuite);
            return this;
        }

        public Builder beforeSuite(BeforeSuite beforeSuite) {
            this.beforeSuite.add(beforeSuite);
            return this;
        }

        public Builder afterSuite(List<AfterSuite> afterSuite) {
            this.afterSuite.addAll(afterSuite);
            return this;
        }

        public Builder afterSuite(AfterSuite afterSuite) {
            this.afterSuite.add(afterSuite);
            return this;
        }

        public Builder functionRegistry(FunctionRegistry functionRegistry) {
            this.functionRegistry = functionRegistry;
            return this;
        }

        public Builder validationMatcherRegistry(ValidationMatcherRegistry validationMatcherRegistry) {
            this.validationMatcherRegistry = validationMatcherRegistry;
            return this;
        }

        public Builder globalVariables(GlobalVariables globalVariables) {
            this.globalVariables = globalVariables;
            return this;
        }

        public Builder messageValidatorRegistry(MessageValidatorRegistry messageValidatorRegistry) {
            this.messageValidatorRegistry = messageValidatorRegistry;
            return this;
        }

        public Builder messageListeners(MessageListeners messageListeners) {
            this.messageListeners = messageListeners;
            return this;
        }

        public Builder messageListener(MessageListener messageListeners) {
            this.messageListeners.addMessageListener(messageListeners);
            return this;
        }

        public Builder endpointFactory(EndpointFactory endpointFactory) {
            this.endpointFactory = endpointFactory;
            return this;
        }

        public Builder referenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public Builder messageProcessors(MessageProcessors messageProcessors) {
            this.messageProcessors = messageProcessors;
            return this;
        }

        public Builder namespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
            this.namespaceContextBuilder = namespaceContextBuilder;
            return this;
        }

        public Builder typeConverter(TypeConverter converter) {
            this.typeConverter = converter;
            return this;
        }

        public Builder logModifier(LogModifier modifier) {
            this.logModifier = modifier;
            return this;
        }

        public CitrusContext build() {
            if (this.testContextFactory == null) {
                this.testContextFactory = TestContextFactory.newInstance();
                this.testContextFactory.setFunctionRegistry(this.functionRegistry);
                this.testContextFactory.setValidationMatcherRegistry(this.validationMatcherRegistry);
                this.testContextFactory.setGlobalVariables(this.globalVariables);
                this.testContextFactory.setMessageValidatorRegistry(this.messageValidatorRegistry);
                this.testContextFactory.setTestListeners(this.testListeners);
                this.testContextFactory.setTestActionListeners(this.testActionListeners);
                this.testContextFactory.setMessageListeners(this.messageListeners);
                this.testContextFactory.setMessageProcessors(this.messageProcessors);
                this.testContextFactory.setEndpointFactory(this.endpointFactory);
                this.testContextFactory.setReferenceResolver(this.referenceResolver);
                this.testContextFactory.setNamespaceContextBuilder(this.namespaceContextBuilder);
                this.testContextFactory.setTypeConverter(this.typeConverter);
                this.testContextFactory.setLogModifier(this.logModifier);
            }
            return new CitrusContext(this);
        }
    }
}

