/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main.scan;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.citrusframework.TestClass;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.scan.AbstractTestScanner;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathTestScanner
extends AbstractTestScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathTestScanner.class);
    private final Class<? extends Annotation> annotationType;
    private final ClasspathResourceResolver resolver = new ClasspathResourceResolver();

    public ClassPathTestScanner(Class<? extends Annotation> annotationType, String ... includes) {
        super(includes);
        this.annotationType = annotationType;
    }

    public List<TestClass> findTestsInPackage(String packageName) {
        try {
            Set resources = this.resolver.getClasses(packageName);
            ArrayList<String> classes = new ArrayList<String>();
            for (Path resource : resources) {
                String className = String.format("%s.%s", packageName, FileUtils.getBaseName(String.valueOf(resource.getFileName())));
                if (!this.isIncluded(className)) continue;
                classes.add(className);
            }
            return classes.stream().distinct().map(TestClass::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to scan classpath package '%s'", packageName), (Throwable)e);
        }
    }

    @Override
    protected boolean isIncluded(String className) {
        if (!super.isIncluded(className)) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz.isAnnotationPresent(this.annotationType)) {
                return true;
            }
            AtomicBoolean hasTestMethod = new AtomicBoolean(false);
            ReflectionHelper.doWithMethods(clazz, method -> {
                if (method.getDeclaredAnnotation(this.annotationType) != null) {
                    hasTestMethod.set(true);
                }
            });
            return hasTestMethod.get();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            logger.warn("Unable to access class: " + className);
            return false;
        }
    }
}

