/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.correlation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.DefaultObjectStore;
import org.citrusframework.message.correlation.ObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCorrelationManager<T>
implements CorrelationManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCorrelationManager.class);
    private ObjectStore<T> objectStore = new DefaultObjectStore();

    public void saveCorrelationKey(String correlationKeyName, String correlationKey, TestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Saving correlation key for '%s'", correlationKeyName));
        }
        context.setVariable(correlationKeyName, (Object)correlationKey);
    }

    public String getCorrelationKey(String correlationKeyName, TestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Get correlation key for '%s'", correlationKeyName));
        }
        if (context.getVariables().containsKey(correlationKeyName)) {
            return context.getVariable(correlationKeyName);
        }
        throw new CitrusRuntimeException(String.format("Failed to get correlation key for '%s'", correlationKeyName));
    }

    public void store(String correlationKey, T object) {
        if (object == null) {
            logger.warn(String.format("Ignore correlated null object for '%s'", correlationKey));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Saving correlated object for '%s'", correlationKey));
        }
        this.objectStore.add(correlationKey, object);
    }

    public T find(String correlationKey, long timeout) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Finding correlated object for '%s'", correlationKey));
        }
        return (T)this.objectStore.remove(correlationKey);
    }

    public void setObjectStore(ObjectStore<T> store) {
        this.objectStore = store;
    }

    public ObjectStore<T> getObjectStore() {
        return this.objectStore;
    }
}

