/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final String FILE_EXTENSION_JAVA = ".java";
    public static final String FILE_EXTENSION_XML = ".xml";
    public static final String FILE_EXTENSION_GROOVY = ".groovy";
    public static final String FILE_EXTENSION_YAML = ".yaml";
    public static final String FILE_PATH_CHARSET_PARAMETER = CitrusSettings.getFilePathCharsetParameter();
    private static boolean simulationMode = false;

    private FileUtils() {
    }

    public static void setSimulationMode(boolean mode) {
        simulationMode = mode;
    }

    public static String readToString(Resource resource) throws IOException {
        return FileUtils.readToString(resource, FileUtils.getDefaultCharset());
    }

    public static String readToString(InputStream inputStream) throws IOException {
        return FileUtils.readToString(inputStream, FileUtils.getDefaultCharset());
    }

    public static String readToString(File file) throws IOException {
        return FileUtils.readToString(new FileInputStream(file), FileUtils.getDefaultCharset());
    }

    public static String readToString(Resource resource, Charset charset) throws IOException {
        if (simulationMode) {
            resource.getLocation();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Reading file resource: '%s' (encoding is '%s')", resource.getLocation(), charset.displayName()));
        }
        return FileUtils.readToString(resource.getInputStream(), charset);
    }

    public static String readToString(InputStream inputStream, Charset charset) throws IOException {
        return new String(inputStream.readAllBytes(), charset);
    }

    public static void writeToFile(InputStream inputStream, File file) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Writing file resource: '%s'", file.getName()));
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new CitrusRuntimeException("Unable to create folder structure for file: " + file.getPath());
        }
        try (InputStream inputStream2 = inputStream;){
            Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write file", (Throwable)e);
        }
    }

    public static void writeToFile(String content, File file) {
        FileUtils.writeToFile(content, file, FileUtils.getDefaultCharset());
    }

    public static void writeToFile(String content, File file, Charset charset) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Writing file resource: '%s' (encoding is '%s')", file.getName(), charset.displayName()));
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new CitrusRuntimeException("Unable to create folder structure for file: " + file.getPath());
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
            ((OutputStream)fos).write(content.getBytes(charset));
            ((OutputStream)fos).flush();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write file", (Throwable)e);
        }
    }

    public static List<File> findFiles(String startDir, Set<String> fileNamePatterns) {
        ArrayList<File> files = new ArrayList<File>();
        Stack<File> dirs = new Stack<File>();
        File startdir = new File(startDir);
        if (!startdir.exists()) {
            throw new CitrusRuntimeException("Test directory " + startdir.getAbsolutePath() + " does not exist");
        }
        if (startdir.isDirectory()) {
            dirs.push(startdir);
        }
        while (dirs.size() > 0) {
            File file = (File)dirs.pop();
            File[] foundFiles = file.listFiles((dir, name) -> {
                File tmp = new File(dir.getPath() + File.separator + name);
                boolean accepted = tmp.isDirectory();
                for (String fileNamePattern : fileNamePatterns) {
                    if (!name.matches(fileNamePattern)) continue;
                    accepted = true;
                    break;
                }
                return accepted && !name.startsWith("CVS") && !name.startsWith(".svn") && !name.startsWith(".git");
            });
            for (File found : Optional.ofNullable(foundFiles).orElseGet(() -> new File[0])) {
                if (found.isDirectory()) {
                    dirs.push(found);
                    continue;
                }
                files.add(found);
            }
        }
        return files;
    }

    public static Resource getFileResource(String filePath, TestContext context) {
        return FileUtils.getFileResource(context.replaceDynamicContentInString(filePath));
    }

    public static Resource getFileResource(String filePath) {
        String path = filePath.contains(FILE_PATH_CHARSET_PARAMETER) ? filePath.substring(0, filePath.indexOf(FILE_PATH_CHARSET_PARAMETER)) : filePath;
        return Resources.create((String)path);
    }

    public static Charset getDefaultCharset() {
        return Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING);
    }

    public static Charset getCharset(String path) {
        if (path.contains(FILE_PATH_CHARSET_PARAMETER)) {
            return Charset.forName(path.substring(path.indexOf(FILE_PATH_CHARSET_PARAMETER) + FILE_PATH_CHARSET_PARAMETER.length()));
        }
        return FileUtils.getDefaultCharset();
    }

    public static String getFileExtension(String path) {
        if (path.indexOf(".") > 0) {
            return path.substring(path.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static Properties loadAsProperties(Resource resource) {
        Properties properties = new Properties();
        try (InputStream is = resource.getInputStream();){
            String filename = FileUtils.getFileName(resource.getLocation());
            if (filename != null && filename.endsWith(FILE_EXTENSION_XML)) {
                properties.loadFromXML(is);
            } else {
                properties.load(is);
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load properties from file", (Throwable)e);
        }
        return properties;
    }

    public static String getFileName(String path) {
        if (path == null || path.isBlank()) {
            return "";
        }
        int separatorIndex = path.replace("\\", "/").lastIndexOf("/");
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.indexOf(46) > 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public static String getBasePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        String fileSeparator = filePath.contains("/") ? "/" : (filePath.contains("\\") ? "\\" : File.separator);
        if (filePath.contains(fileSeparator)) {
            return filePath.substring(0, filePath.lastIndexOf(fileSeparator));
        }
        return filePath;
    }

    public static byte[] copyToByteArray(File file) {
        byte[] byArray;
        block9: {
            if (file == null) {
                return new byte[0];
            }
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                byArray = in.readAllBytes();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read file content", (Throwable)e);
                }
            }
            in.close();
        }
        return byArray;
    }

    public static byte[] copyToByteArray(Resource resource) {
        byte[] byArray;
        block9: {
            InputStream in = resource.getInputStream();
            try {
                if (in == null) {
                    throw new CitrusRuntimeException(String.format("Unable to access input stream of resource %s", resource.getLocation()));
                }
                byArray = in.readAllBytes();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read resource", (Throwable)e);
                }
            }
            in.close();
        }
        return byArray;
    }

    public static byte[] copyToByteArray(InputStream inputStream) {
        byte[] byArray;
        block8: {
            InputStream inputStream2 = inputStream;
            try {
                byArray = inputStream.readAllBytes();
                if (inputStream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read input stream", (Throwable)e);
                }
            }
            inputStream2.close();
        }
        return byArray;
    }

    public static String constructContentType(String contentType, Charset charset) {
        return contentType + FILE_PATH_CHARSET_PARAMETER + charset;
    }
}

