/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.variable.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.AbstractMessageProcessor;
import org.citrusframework.spi.Resource;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataDictionary<T>
extends AbstractMessageProcessor
implements DataDictionary<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataDictionary.class);
    private String name = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean globalScope = true;
    protected Map<String, String> mappings = new LinkedHashMap<String, String>();
    protected Resource mappingFile;
    private DataDictionary.PathMappingStrategy pathMappingStrategy = DataDictionary.PathMappingStrategy.EXACT;

    protected <V> V convertIfNecessary(String value, V originalValue, TestContext context) {
        if (originalValue == null) {
            return (V)context.replaceDynamicContentInString(value);
        }
        return (V)context.getTypeConverter().convertIfNecessary((Object)context.replaceDynamicContentInString(value), originalValue.getClass());
    }

    public void initialize() {
        if (this.mappingFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading data dictionary mapping " + this.mappingFile.getLocation());
            }
            Properties props = new Properties();
            try (InputStream inputStream = this.mappingFile.getInputStream();){
                props.load(inputStream);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("Loading data dictionary mapping: " + key + "=" + props.getProperty(key));
                }
                if (logger.isDebugEnabled() && this.mappings.containsKey(key)) {
                    logger.debug("Overwriting data dictionary mapping " + key + " old value:" + this.mappings.get(key) + " new value:" + props.getProperty(key));
                }
                this.mappings.put(key, props.getProperty(key));
            }
            logger.debug("Loaded data dictionary mapping " + this.mappingFile.getLocation());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGlobalScope() {
        return this.globalScope;
    }

    public void setGlobalScope(boolean scope) {
        this.globalScope = scope;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public Resource getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(Resource mappingFile) {
        this.mappingFile = mappingFile;
    }

    public DataDictionary.PathMappingStrategy getPathMappingStrategy() {
        return this.pathMappingStrategy;
    }

    public void setPathMappingStrategy(DataDictionary.PathMappingStrategy pathMappingStrategy) {
        this.pathMappingStrategy = pathMappingStrategy;
    }
}

