/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.citrusframework.Completable;
import org.citrusframework.TestAction;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessageDirection;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageType;
import org.citrusframework.message.builder.MessageBuilderSupport;
import org.citrusframework.message.builder.SendMessageBuilderSupport;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.util.IsXmlPredicate;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.SchemaValidator;
import org.citrusframework.validation.context.DefaultValidationContext;
import org.citrusframework.validation.context.SchemaValidationContext;
import org.citrusframework.validation.json.JsonMessageValidationContext;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageAction
extends AbstractTestAction
implements Completable {
    private static final String REPORT_ENABLED_ENV = "CITRUS_SUMMARY_REPORT_ENABLED";
    private final Endpoint endpoint;
    private final String endpointUri;
    private final boolean schemaValidation;
    private final String schemaRepository;
    private final String schema;
    private final List<VariableExtractor> variableExtractors;
    private final List<MessageProcessor> messageProcessors;
    private final MessageBuilder messageBuilder;
    private final boolean forkMode;
    private final String messageType;
    private final DataDictionary<?> dataDictionary;
    private CompletableFuture<TestContext> finished;
    private static final Logger logger = LoggerFactory.getLogger(SendMessageAction.class);

    public SendMessageAction(SendMessageActionBuilder<?, ?, ?> builder) {
        super("send", builder);
        this.forkMode = builder.forkMode;
        this.endpoint = builder.getEndpoint();
        this.endpointUri = builder.getEndpointUri();
        this.schemaValidation = ((SendMessageBuilderSupport)builder.getMessageBuilderSupport()).isSchemaValidation();
        this.schema = ((SendMessageBuilderSupport)builder.getMessageBuilderSupport()).getSchema();
        this.schemaRepository = ((SendMessageBuilderSupport)builder.getMessageBuilderSupport()).getSchemaRepository();
        this.variableExtractors = builder.getVariableExtractors();
        this.messageProcessors = builder.getMessageProcessors();
        this.messageBuilder = ((SendMessageBuilderSupport)builder.getMessageBuilderSupport()).getMessageBuilder();
        this.messageType = ((SendMessageBuilderSupport)builder.getMessageBuilderSupport()).getMessageType();
        this.dataDictionary = ((SendMessageBuilderSupport)builder.getMessageBuilderSupport()).getDataDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(TestContext context) {
        Message message = this.createMessage(context, this.messageType);
        this.finished = new CompletableFuture();
        this.finished.whenComplete((ctx, ex) -> {
            if (ex != null) {
                logger.warn("Failure in forked send action: " + ex.getMessage());
            } else {
                for (Exception ctxEx : ctx.getExceptions()) {
                    logger.warn(ctxEx.getMessage());
                }
            }
        });
        for (VariableExtractor variableExtractor : this.variableExtractors) {
            variableExtractor.extractVariables(message, context);
        }
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (StringUtils.hasText(message.getName())) {
            context.getMessageStore().storeMessage(message.getName(), message);
        } else {
            context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName((TestAction)this, messageEndpoint), message);
        }
        if (this.forkMode) {
            logger.debug("Forking message sending action ...");
            ExecutorService taskExecutor = Executors.newSingleThreadExecutor();
            taskExecutor.execute(() -> {
                try {
                    this.validateMessage(message, context);
                    messageEndpoint.createProducer().send(message, context);
                }
                catch (Exception e) {
                    if (e instanceof CitrusRuntimeException) {
                        CitrusRuntimeException runtimeEx = (CitrusRuntimeException)((Object)((Object)e));
                        context.addException(runtimeEx);
                    } else {
                        context.addException(new CitrusRuntimeException((Throwable)e));
                    }
                }
                finally {
                    this.finished.complete(context);
                }
            });
        } else {
            try {
                this.validateMessage(message, context);
                messageEndpoint.createProducer().send(message, context);
            }
            finally {
                this.finished.complete(context);
            }
        }
    }

    protected void validateMessage(Message message, TestContext context) {
        List schemaValidators = null;
        DefaultValidationContext validationContext = null;
        String payload = (String)message.getPayload(String.class);
        if ((this.isSchemaValidation() || SendMessageAction.isJsonSchemaValidationEnabled()) && IsJsonPredicate.getInstance().test(payload)) {
            schemaValidators = context.getMessageValidatorRegistry().findSchemaValidators(MessageType.JSON.name(), message);
            validationContext = JsonMessageValidationContext.Builder.json().schemaValidation(this.schemaValidation).schema(this.schema).schemaRepository(this.schemaRepository).build();
        } else if ((this.isSchemaValidation() || SendMessageAction.isXmlSchemaValidationEnabled()) && IsXmlPredicate.getInstance().test(payload)) {
            schemaValidators = context.getMessageValidatorRegistry().findSchemaValidators(MessageType.XML.name(), message);
            validationContext = ((XmlMessageValidationContext.Builder)((XmlMessageValidationContext.Builder)((XmlMessageValidationContext.Builder)XmlMessageValidationContext.Builder.xml().schemaValidation(this.schemaValidation)).schema(this.schema)).schemaRepository(this.schemaRepository)).build();
        }
        if (schemaValidators != null) {
            for (SchemaValidator validator : schemaValidators) {
                validator.validate(message, context, (SchemaValidationContext)validationContext);
            }
        }
    }

    private static boolean isJsonSchemaValidationEnabled() {
        return Boolean.getBoolean("citrus.validation.outbound.schema.enabled") || Boolean.getBoolean("citrus.validation.outbound.json.schema.enabled") || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_SCHEMA_ENABLED")) || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_JSON_SCHEMA_ENABLED"));
    }

    private static boolean isXmlSchemaValidationEnabled() {
        return Boolean.getBoolean("citrus.validation.outbound.schema.enabled") || Boolean.getBoolean("citrus.validation.outbound.xml.schema.enabled") || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_SCHEMA_ENABLED")) || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_XML_SCHEMA_ENABLED"));
    }

    @Override
    public boolean isDisabled(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (this.getActor() == null && messageEndpoint.getActor() != null) {
            return messageEndpoint.getActor().isDisabled();
        }
        return super.isDisabled(context);
    }

    public boolean isDone(TestContext context) {
        return Optional.ofNullable(this.finished).map(future -> future.isDone() || this.isDisabled(context)).orElseGet(() -> this.isDisabled(context));
    }

    protected Message createMessage(TestContext context, String messageType) {
        Message message = this.messageBuilder.build(context, messageType);
        if (message.getPayload() != null) {
            context.getMessageProcessors(MessageDirection.OUTBOUND).forEach(processor -> processor.process(message, context));
            if (this.dataDictionary != null) {
                this.dataDictionary.process(message, context);
            }
            this.messageProcessors.forEach(processor -> processor.process(message, context));
        }
        return message;
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText(this.endpointUri)) {
            return context.getEndpointFactory().create(this.endpointUri, context);
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public String getSchemaRepository() {
        return this.schemaRepository;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<VariableExtractor> getVariableExtractors() {
        return this.variableExtractors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public boolean isForkMode() {
        return this.forkMode;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public static abstract class SendMessageActionBuilder<T extends SendMessageAction, M extends SendMessageBuilderSupport<T, B, M>, B extends SendMessageActionBuilder<T, M, B>>
    extends MessageBuilderSupport.MessageActionBuilder<T, M, B> {
        protected boolean forkMode = false;
        protected CompletableFuture<Void> finished;

        public B fork(boolean forkMode) {
            this.forkMode = forkMode;
            return (B)((SendMessageActionBuilder)this.self);
        }

        public final T build() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = this.getMessageBuilderSupport();
            }
            if (this.referenceResolver != null && ((SendMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName() != null) {
                ((SendMessageBuilderSupport)this.messageBuilderSupport).dictionary((DataDictionary)this.referenceResolver.resolve(((SendMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName(), DataDictionary.class));
            }
            return (T)((SendMessageAction)this.doBuild());
        }
    }

    public static class SendMessageActionBuilderSupport
    extends SendMessageBuilderSupport<SendMessageAction, Builder, SendMessageActionBuilderSupport> {
        public SendMessageActionBuilderSupport(Builder delegate) {
            super(delegate);
        }
    }

    public static final class Builder
    extends SendMessageActionBuilder<SendMessageAction, SendMessageActionBuilderSupport, Builder> {
        public static Builder send() {
            return new Builder();
        }

        public static Builder send(Endpoint messageEndpoint) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpoint);
            return builder;
        }

        public static Builder send(String messageEndpointUri) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpointUri);
            return builder;
        }

        @Override
        public SendMessageActionBuilderSupport getMessageBuilderSupport() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = new SendMessageActionBuilderSupport((Builder)this.self);
            }
            return (SendMessageActionBuilderSupport)super.getMessageBuilderSupport();
        }

        @Override
        public SendMessageAction doBuild() {
            return new SendMessageAction(this);
        }
    }
}

