/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.CitrusSettings;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.xml.StringResult;
import org.citrusframework.xml.StringSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformAction
extends AbstractTestAction {
    private final String xmlData;
    private final String xmlResourcePath;
    private final String xmlResourceCharset;
    private final String xsltData;
    private final String xsltResourcePath;
    private final String xsltResourceCharset;
    private final String targetVariable;
    private static final Logger logger = LoggerFactory.getLogger(TransformAction.class);

    public TransformAction(Builder builder) {
        super("transform", builder);
        this.xmlData = builder.xmlData;
        this.xmlResourcePath = builder.xmlResourcePath;
        this.xmlResourceCharset = builder.xmlResourceCharset;
        this.xsltData = builder.xsltData;
        this.xsltResourcePath = builder.xsltResourcePath;
        this.xsltResourceCharset = builder.xsltResourceCharset;
        this.targetVariable = builder.targetVariable;
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting XSLT transformation");
            }
            StringSource xmlSource = null;
            if (this.xmlResourcePath != null) {
                xmlSource = new StringSource(context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.xmlResourcePath, context), Charset.forName(context.replaceDynamicContentInString(this.xmlResourceCharset)))));
            } else if (this.xmlData != null) {
                xmlSource = new StringSource(context.replaceDynamicContentInString(this.xmlData));
            } else {
                throw new CitrusRuntimeException("Neither inline XML nor external file resource is defined for bean. Cannot transform XML document.");
            }
            StringSource xsltSource = null;
            if (this.xsltResourcePath != null) {
                xsltSource = new StringSource(context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.xsltResourcePath, context), Charset.forName(context.replaceDynamicContentInString(this.xsltResourceCharset)))));
            } else if (this.xsltData != null) {
                xsltSource = new StringSource(context.replaceDynamicContentInString(this.xsltData));
            } else {
                throw new CitrusRuntimeException("Neither inline XSLT nor external file resource is defined for bean. Cannot transform XSLT document.");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer((Source)xsltSource);
            StringResult result = new StringResult();
            transformer.transform((Source)xmlSource, (Result)result);
            context.setVariable(this.targetVariable, (Object)result.toString());
            logger.info("Finished XSLT transformation");
        }
        catch (IOException | TransformerException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public String getXmlData() {
        return this.xmlData;
    }

    public String getXmlResourcePath() {
        return this.xmlResourcePath;
    }

    public String getXsltData() {
        return this.xsltData;
    }

    public String getXsltResourcePath() {
        return this.xsltResourcePath;
    }

    public String getTargetVariable() {
        return this.targetVariable;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<TransformAction, Builder> {
        private String xmlData;
        private String xmlResourcePath;
        private String xmlResourceCharset = CitrusSettings.CITRUS_FILE_ENCODING;
        private String xsltData;
        private String xsltResourcePath;
        private String xsltResourceCharset = CitrusSettings.CITRUS_FILE_ENCODING;
        private String targetVariable = "transform-result";

        public static Builder transform() {
            return new Builder();
        }

        public Builder result(String variable) {
            this.targetVariable = variable;
            return this;
        }

        public Builder variable(String variable) {
            this.targetVariable = variable;
            return this;
        }

        public Builder source(String xmlData) {
            this.xmlData = xmlData;
            return this;
        }

        public Builder source(Resource xmlResource) {
            return this.source(xmlResource, FileUtils.getDefaultCharset());
        }

        public Builder sourceFile(String xmlResourcePath) {
            this.xmlResourcePath = xmlResourcePath;
            return this;
        }

        public Builder sourceFile(String xmlResourcePath, String charset) {
            this.xmlResourcePath = xmlResourcePath;
            this.xmlResourceCharset = charset;
            return this;
        }

        public Builder source(Resource xmlResource, Charset charset) {
            try {
                this.xmlData = FileUtils.readToString(xmlResource, charset);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read xml resource", (Throwable)e);
            }
            return this;
        }

        public Builder xslt(String xsltData) {
            this.xsltData = xsltData;
            return this;
        }

        public Builder xslt(Resource xsltResource) {
            return this.xslt(xsltResource, FileUtils.getDefaultCharset());
        }

        public Builder xsltFile(String xsltResourcePath) {
            this.xsltResourcePath = xsltResourcePath;
            return this;
        }

        public Builder xsltFile(String xsltResourcePath, String charset) {
            this.xsltResourcePath = xsltResourcePath;
            this.xsltResourceCharset = charset;
            return this;
        }

        public Builder xslt(Resource xsltResource, Charset charset) {
            try {
                this.xsltData = FileUtils.readToString(xsltResource, charset);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read xstl resource", (Throwable)e);
            }
            return this;
        }

        public TransformAction build() {
            return new TransformAction(this);
        }
    }
}

