/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.condition;

import java.io.File;
import org.citrusframework.condition.AbstractCondition;
import org.citrusframework.context.TestContext;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCondition
extends AbstractCondition {
    private String filePath;
    private File file;
    private static final Logger logger = LoggerFactory.getLogger(FileCondition.class);

    public FileCondition() {
        super("file-check");
    }

    public boolean isSatisfied(TestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Checking file path '%s'", this.file != null ? this.file.getPath() : this.filePath));
        }
        if (this.file != null) {
            return this.file.exists() && this.file.isFile();
        }
        try {
            return FileUtils.getFileResource(context.replaceDynamicContentInString(this.filePath), context).getFile().isFile();
        }
        catch (Exception e) {
            logger.warn(String.format("Failed to access file resource '%s'", e.getMessage()));
            return false;
        }
    }

    public String getSuccessMessage(TestContext context) {
        return String.format("File condition success - file '%s' does exist", this.file != null ? this.file.getPath() : context.replaceDynamicContentInString(this.filePath));
    }

    public String getErrorMessage(TestContext context) {
        return String.format("Failed to check file condition - file '%s' does not exist", this.file != null ? this.file.getPath() : context.replaceDynamicContentInString(this.filePath));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        return "FileCondition{filePath='" + this.filePath + "', file=" + this.file + ", name=" + this.getName() + "}";
    }
}

