/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractSuiteContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractSuiteActionContainer;
import org.citrusframework.container.AfterSuite;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceAfterSuite
extends AbstractSuiteActionContainer
implements AfterSuite {
    private static final Logger logger = LoggerFactory.getLogger(SequenceAfterSuite.class);

    @Override
    public void doExecute(TestContext context) {
        boolean success = true;
        logger.info("Entering after suite block");
        if (logger.isDebugEnabled()) {
            logger.debug("Executing " + this.actions.size() + " actions after suite");
            logger.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            try {
                action.execute(context);
            }
            catch (Exception e) {
                logger.error("After suite action failed " + action.getName() + "Nested exception is: ", (Throwable)e);
                logger.error("Continue after suite actions");
                success = false;
            }
        }
        if (!success) {
            throw new CitrusRuntimeException("Error in after suite");
        }
    }

    public static class Builder
    extends AbstractSuiteContainerBuilder<SequenceAfterSuite, Builder> {
        public static Builder afterSuite() {
            return new Builder();
        }

        @Override
        public SequenceAfterSuite doBuild() {
            return new SequenceAfterSuite();
        }
    }
}

