/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.citrusframework.TestAction;
import org.citrusframework.TestCase;
import org.citrusframework.container.TestActionContainer;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.report.AbstractTestListener;
import org.citrusframework.report.FailureStackElement;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FailureStackTestListener
extends AbstractTestListener {
    private static final Logger logger = LoggerFactory.getLogger(FailureStackTestListener.class);

    @Override
    public void onTestFailure(TestCase test, Throwable cause) {
        if (cause instanceof CitrusRuntimeException) {
            ((CitrusRuntimeException)cause).setFailureStack(FailureStackTestListener.getFailureStack(test));
        }
    }

    public static List<FailureStackElement> getFailureStack(TestCase test) {
        ArrayList<FailureStackElement> failureStack = new ArrayList<FailureStackElement>();
        try {
            String testFilePath = test.getPackageName().replace('.', '/') + "/" + test.getName();
            Resource testFileResource = Resources.fromClasspath((String)(testFilePath + ".xml"));
            if (!testFileResource.exists()) {
                return failureStack;
            }
            if (test.getActiveAction() == null) {
                failureStack.add(new FailureStackElement(testFilePath, "init", Long.valueOf(0L)));
                return failureStack;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(new FailureStackContentHandler(failureStack, test, testFilePath));
            reader.parse(new InputSource(testFileResource.getInputStream()));
        }
        catch (Exception e) {
            logger.warn("Failed to locate line numbers for failure stack trace", (Throwable)e);
        }
        return failureStack;
    }

    private static final class FailureStackContentHandler
    extends DefaultHandler {
        private final List<FailureStackElement> failureStack;
        private final TestCase test;
        private final String testFilePath;
        private Locator locator;
        private FailureStackFinder stackFinder;
        private boolean findLineEnding = false;
        private String failedActionName;

        private FailureStackContentHandler(List<FailureStackElement> failureStack, TestCase test, String testFilePath) {
            this.failureStack = failureStack;
            this.test = test;
            this.testFilePath = testFilePath;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("actions")) {
                this.stackFinder = new FailureStackFinder((TestActionContainer)this.test);
                return;
            }
            if (this.stackFinder != null && this.stackFinder.isFailureStackElement(qName)) {
                this.failureStack.add(new FailureStackElement(this.testFilePath, qName, Long.valueOf(this.locator.getLineNumber())));
                if (this.stackFinder.getNestedActionContainer() != null && this.stackFinder.getNestedActionContainer().getActiveAction() != null) {
                    this.stackFinder = new FailureStackFinder(this.stackFinder.getNestedActionContainer());
                } else {
                    this.stackFinder = null;
                    this.findLineEnding = true;
                    this.failedActionName = qName;
                }
            }
            super.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.findLineEnding && qName.equals(this.failedActionName)) {
                FailureStackElement failureStackElement = this.failureStack.get(this.failureStack.size() - 1);
                failureStackElement.setLineNumberEnd(Long.valueOf(this.locator.getLineNumber()));
                this.findLineEnding = false;
            }
            super.endElement(uri, localName, qName);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    private static class FailureStackFinder {
        private Stack<TestAction> actionStack = new Stack();
        private TestAction action = null;

        public FailureStackFinder(TestActionContainer container) {
            int lastActionIndex;
            for (int i = lastActionIndex = container.getActionIndex(container.getActiveAction()); i >= 0; --i) {
                this.actionStack.add((TestAction)container.getActions().get(i));
            }
        }

        public boolean isFailureStackElement(String eventElement) {
            if (this.action == null) {
                this.action = this.actionStack.pop();
            }
            if (eventElement.equals(this.action.getName())) {
                if (this.action instanceof TestActionContainer && !this.actionStack.isEmpty()) {
                    TestActionContainer container = (TestActionContainer)this.action;
                    for (int i = container.getActions().size() - 1; i >= 0; --i) {
                        this.actionStack.add((TestAction)container.getActions().get(i));
                    }
                }
                if (!this.actionStack.isEmpty()) {
                    this.action = null;
                }
            } else {
                return false;
            }
            return this.actionStack.isEmpty();
        }

        public TestActionContainer getNestedActionContainer() {
            if (this.action instanceof TestActionContainer) {
                return (TestActionContainer)this.action;
            }
            return null;
        }
    }
}

