/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.citrusframework.Completable;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncTestAction
extends AbstractTestAction
implements Completable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAsyncTestAction.class);
    private Future<?> finished;

    @Override
    public final void doExecute(TestContext context) {
        CompletableFuture result = new CompletableFuture();
        result.whenComplete((ctx, throwable) -> {
            if (throwable != null) {
                this.onError((TestContext)ctx, (Throwable)throwable);
            } else if (ctx.hasExceptions()) {
                this.onError((TestContext)ctx, (Throwable)ctx.getExceptions().get(0));
            } else {
                this.onSuccess((TestContext)ctx);
            }
        });
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.finished = executor.submit(() -> {
            try {
                this.doExecuteAsync(context);
            }
            catch (Error | Exception e) {
                logger.warn("Async test action execution raised error", e);
                if (e instanceof CitrusRuntimeException) {
                    CitrusRuntimeException citrusEx = (CitrusRuntimeException)e;
                    context.addException(citrusEx);
                } else {
                    context.addException(new CitrusRuntimeException(e));
                }
            }
            finally {
                result.complete(context);
            }
        });
    }

    public boolean isDone(TestContext context) {
        return Optional.ofNullable(this.finished).map(future -> future.isDone() || this.isDisabled(context)).orElseGet(() -> this.isDisabled(context));
    }

    public abstract void doExecuteAsync(TestContext var1);

    public void onSuccess(TestContext context) {
    }

    public void onError(TestContext context, Throwable error) {
    }
}

