/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.core.AbstractDateFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDateFunction
extends AbstractDateFunction {
    private static final Logger logger = LoggerFactory.getLogger(ChangeDateFunction.class);
    private final CalendarProvider calendarProvider = new CalendarProvider();

    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        Calendar calendar = this.calendarProvider.getInstance();
        String result = "";
        SimpleDateFormat dateFormat = parameterList.size() > 2 ? new SimpleDateFormat(parameterList.get(2)) : this.getDefaultDateFormat();
        try {
            calendar.setTime(dateFormat.parse(parameterList.get(0)));
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        if (parameterList.size() > 1) {
            this.applyDateOffset(calendar, parameterList.get(1));
        }
        try {
            result = dateFormat.format(calendar.getTime());
        }
        catch (RuntimeException e) {
            logger.error("Error while formatting dateParameter value ", (Throwable)e);
            throw new CitrusRuntimeException((Throwable)e);
        }
        return result;
    }

    static class CalendarProvider {
        private CalendarProvider() {
        }

        Calendar getInstance() {
            return Calendar.getInstance();
        }
    }
}

