/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.report.AbstractOutputFileReporter;
import org.citrusframework.report.FailureStackElement;
import org.citrusframework.report.HtmlReporterSettings;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestResults;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.PropertyUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReporter
extends AbstractOutputFileReporter
implements TestListener {
    private static final Logger logger = LoggerFactory.getLogger(HtmlReporter.class);
    private Map<String, ResultDetail> details = new HashMap<String, ResultDetail>();
    private String reportTemplate = HtmlReporterSettings.getReportTemplate();
    private String testDetailTemplate = HtmlReporterSettings.getReportDetailTemplate();
    private final String outputDirectory = HtmlReporterSettings.getReportDirectory();
    private String reportFileName = HtmlReporterSettings.getReportFile();
    private DateFormat dateFormat = DateFormat.getDateInstance(2);
    private String logo = HtmlReporterSettings.getReportLogo();
    private boolean enabled = HtmlReporterSettings.isReportEnabled();

    @Override
    public String getReportContent(TestResults testResults) {
        StringBuilder reportDetails = new StringBuilder();
        logger.debug("Generating HTML test report");
        try {
            String testDetails = FileUtils.readToString(FileUtils.getFileResource(this.testDetailTemplate));
            String emptyString = "";
            testResults.doWithResults(result -> {
                ResultDetail detail = Optional.ofNullable(this.details.get(result.getTestName())).orElseGet(ResultDetail::new);
                Properties detailProps = new Properties();
                detailProps.put("test.style.class", result.getResult().toLowerCase());
                detailProps.put("test.case.name", result.getTestName());
                detailProps.put("test.author", !StringUtils.hasText(detail.getMetaInfo().getAuthor()) ? "" : detail.getMetaInfo().getAuthor());
                detailProps.put("test.status", detail.getMetaInfo().getStatus().toString());
                detailProps.put("test.creation.date", detail.getMetaInfo().getCreationDate() == null ? "" : this.dateFormat.format(detail.getMetaInfo().getCreationDate()));
                detailProps.put("test.updater", !StringUtils.hasText(detail.getMetaInfo().getLastUpdatedBy()) ? "" : detail.getMetaInfo().getLastUpdatedBy());
                detailProps.put("test.update.date", detail.getMetaInfo().getLastUpdatedOn() == null ? "" : this.dateFormat.format(detail.getMetaInfo().getLastUpdatedOn()));
                detailProps.put("test.description", !StringUtils.hasText(detail.getDescription()) ? "" : detail.getDescription());
                detailProps.put("test.result", result.getResult());
                reportDetails.append(PropertyUtils.replacePropertiesInString(testDetails, detailProps));
                if (result.isFailed() && result.getCause() != null) {
                    reportDetails.append(this.getStackTraceHtml(result.getCause()));
                }
            });
            Properties reportProps = new Properties();
            reportProps.put("test.cnt", Integer.toString(testResults.getSize()));
            reportProps.put("skipped.test.cnt", Integer.toString(testResults.getSkipped()));
            reportProps.put("skipped.test.pct", testResults.getSkippedPercentage());
            reportProps.put("failed.test.cnt", Integer.toString(testResults.getFailed()));
            reportProps.put("failed.test.pct", testResults.getFailedPercentage());
            reportProps.put("success.test.cnt", Integer.toString(testResults.getSuccess()));
            reportProps.put("success.test.pct", testResults.getSuccessPercentage());
            reportProps.put("test.results", reportDetails.toString());
            reportProps.put("logo.data", this.getLogoImageData());
            return PropertyUtils.replacePropertiesInString(FileUtils.readToString(FileUtils.getFileResource(this.reportTemplate)), reportProps);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to generate HTML test report", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLogoImageData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(FileUtils.getFileResource(this.logo).getInputStream());
            byte[] contents = new byte[1024];
            while (reader.read(contents) != -1) {
                os.write(contents);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to add logo image data to HTML report", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.warn("Failed to close logo image resource for HTML report", (Throwable)ex);
                }
            }
            try {
                os.flush();
            }
            catch (IOException ex) {
                logger.warn("Failed to flush logo image stream for HTML report", (Throwable)ex);
            }
        }
        return Base64.encodeBase64String((byte[])os.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCodeSnippetHtml(Throwable cause) {
        StringBuilder codeSnippet = new StringBuilder();
        BufferedReader reader = null;
        try {
            FailureStackElement stackElement;
            CitrusRuntimeException ex;
            if (cause instanceof CitrusRuntimeException && !(ex = (CitrusRuntimeException)cause).getFailureStack().isEmpty() && (stackElement = (FailureStackElement)ex.getFailureStack().pop()).getLineNumberStart() > 0L) {
                String line;
                reader = new BufferedReader(Resources.fromClasspath((String)(stackElement.getTestFilePath() + ".xml")).getReader());
                codeSnippet.append("<div class=\"code-snippet\">");
                codeSnippet.append("<h2 class=\"code-title\">" + stackElement.getTestFilePath() + ".xml</h2>");
                int lineIndex = 1;
                int snippetOffset = 5;
                while ((line = reader.readLine()) != null) {
                    String codeStyle = (long)lineIndex >= stackElement.getLineNumberStart() - (long)snippetOffset && (long)lineIndex < stackElement.getLineNumberStart() || (long)lineIndex > stackElement.getLineNumberEnd() && (long)lineIndex <= stackElement.getLineNumberEnd() + (long)snippetOffset ? "code" : ((long)lineIndex >= stackElement.getLineNumberStart() && (long)lineIndex <= stackElement.getLineNumberEnd() ? "code-failed" : "");
                    if (StringUtils.hasText(codeStyle)) {
                        codeSnippet.append("<pre class=\"" + codeStyle + "\"><span class=\"line-number\">" + lineIndex + ":</span>" + line.replaceAll(">", "&gt;").replaceAll("<", "&lt;") + "</pre>");
                    }
                    ++lineIndex;
                }
                codeSnippet.append("</div>");
            }
        }
        catch (IOException e) {
            logger.error("Failed to construct HTML code snippet", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn("Failed to close test file", (Throwable)e);
                }
            }
        }
        return codeSnippet.toString();
    }

    private String getStackTraceHtml(Throwable cause) {
        StringBuilder stackTraceBuilder = new StringBuilder();
        stackTraceBuilder.append(cause.getClass().getName()).append(": ").append(cause.getMessage()).append("\n ");
        for (int i = 0; i < cause.getStackTrace().length; ++i) {
            stackTraceBuilder.append("\n\t at ");
            stackTraceBuilder.append(cause.getStackTrace()[i]);
        }
        return "<tr><td colspan=\"2\"><div class=\"error-detail\"><pre>" + stackTraceBuilder.toString() + "</pre>" + this.getCodeSnippetHtml(cause) + "</div></td></tr>";
    }

    public void onTestStart(TestCase test) {
    }

    public void onTestFinish(TestCase test) {
    }

    public void onTestSuccess(TestCase test) {
        this.details.put(test.getName(), ResultDetail.build(test));
    }

    public void onTestFailure(TestCase test, Throwable cause) {
        this.details.put(test.getName(), ResultDetail.build(test));
    }

    public void onTestSkipped(TestCase test) {
        this.details.put(test.getName(), ResultDetail.build(test));
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    @Override
    public String getReportDirectory() {
        if (StringUtils.hasText(this.outputDirectory)) {
            return this.outputDirectory;
        }
        return super.getReportDirectory();
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public void setTestDetailTemplate(String testDetailTemplate) {
        this.testDetailTemplate = testDetailTemplate;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    protected boolean isEnabled() {
        return this.enabled;
    }

    private static class ResultDetail {
        private TestCaseMetaInfo metaInfo = new TestCaseMetaInfo();
        private String description;

        private ResultDetail() {
        }

        public static ResultDetail build(TestCase test) {
            ResultDetail detail = new ResultDetail();
            detail.setDescription(test.getDescription());
            detail.setMetaInfo(test.getMetaInfo());
            return detail;
        }

        public TestCaseMetaInfo getMetaInfo() {
            return this.metaInfo;
        }

        public void setMetaInfo(TestCaseMetaInfo metaInfo) {
            this.metaInfo = metaInfo;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

