/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.variable;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.UnknownElementException;
import org.citrusframework.message.Message;
import org.citrusframework.variable.VariableExtractor;

public class MessageHeaderVariableExtractor
implements VariableExtractor {
    private final Map<String, Object> headerMappings;

    public MessageHeaderVariableExtractor() {
        this(new Builder());
    }

    private MessageHeaderVariableExtractor(Builder builder) {
        this.headerMappings = builder.expressions;
    }

    public void extractVariables(Message message, TestContext context) {
        if (this.headerMappings.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.headerMappings.entrySet()) {
            String headerElementName = entry.getKey();
            String targetVariableName = Optional.ofNullable(entry.getValue()).map(Object::toString).orElseThrow(() -> new CitrusRuntimeException(String.format("Variable name must be set for extractor on header '%s'", headerElementName)));
            if (message.getHeader(headerElementName) == null) {
                throw new UnknownElementException("Could not find header element " + headerElementName + " in received header");
            }
            context.setVariable(targetVariableName, (Object)message.getHeader(headerElementName).toString());
        }
    }

    public Map<String, Object> getHeaderMappings() {
        return this.headerMappings;
    }

    public static final class Builder
    implements VariableExtractor.Builder<MessageHeaderVariableExtractor, Builder> {
        private final Map<String, Object> expressions = new LinkedHashMap<String, Object>();

        public static Builder fromHeaders() {
            return new Builder();
        }

        public Builder headers(Map<String, String> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder header(String headerName, String variableName) {
            this.expressions.put(headerName, variableName);
            return this;
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String headerName, Object variableName) {
            this.expressions.put(headerName, variableName);
            return this;
        }

        public MessageHeaderVariableExtractor build() {
            return new MessageHeaderVariableExtractor(this);
        }
    }
}

