/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.Optional;
import org.citrusframework.CitrusVersion;
import org.citrusframework.TestAction;
import org.citrusframework.TestCase;
import org.citrusframework.common.Described;
import org.citrusframework.container.TestActionContainer;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.report.AbstractTestReporter;
import org.citrusframework.report.MessageListener;
import org.citrusframework.report.TestActionListener;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestResults;
import org.citrusframework.report.TestSuiteListener;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;

public class LoggingReporter
extends AbstractTestReporter
implements MessageListener,
TestSuiteListener,
TestListener,
TestActionListener {
    private static Logger inboundMessageLogger;
    private static final Logger enabledInboundMessageLogger;
    private static Logger outboundMessageLogger;
    private static final Logger enabledOutboundMessageLogger;
    private static Logger logger;
    private static final Logger enabledLog;
    private static final Logger noOpLogger;

    @Override
    public void generate(TestResults testResults) {
        this.separator();
        this.newLine();
        this.info("CITRUS TEST RESULTS");
        this.newLine();
        testResults.doWithResults(testResult -> {
            this.info(testResult.toString());
            if (testResult.isFailed()) {
                this.info(Optional.ofNullable(testResult.getCause()).filter(cause -> StringUtils.hasText(cause.getMessage())).map(cause -> " FAILURE: Caused by: " + cause.getClass().getSimpleName() + ": " + cause.getMessage()).orElse(" FAILURE: Caused by: " + Optional.ofNullable(testResult.getErrorMessage()).orElse("Unknown error")));
            }
        });
        this.newLine();
        this.info("TOTAL:\t" + (testResults.getFailed() + testResults.getSuccess()));
        this.debug("SKIPPED:\t" + testResults.getSkipped() + " (" + testResults.getSkippedPercentage() + "%)");
        this.info("FAILED:\t" + testResults.getFailed() + " (" + testResults.getFailedPercentage() + "%)");
        this.info("SUCCESS:\t" + testResults.getSuccess() + " (" + testResults.getSuccessPercentage() + "%)");
        this.newLine();
        this.separator();
    }

    public void onTestFailure(TestCase test, Throwable cause) {
        this.newLine();
        this.error("TEST FAILED " + test.getName() + " <" + test.getPackageName() + "> Nested exception is: ", cause);
        this.separator();
        this.newLine();
    }

    public void onTestSkipped(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("SKIPPING TEST: " + test.getName());
            this.separator();
            this.newLine();
        }
    }

    public void onTestStart(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("STARTING TEST " + test.getName() + " <" + test.getPackageName() + ">");
            this.newLine();
        }
    }

    public void onTestFinish(TestCase test) {
    }

    public void onTestSuccess(TestCase test) {
        this.newLine();
        this.info("TEST SUCCESS " + test.getName() + " (" + test.getPackageName() + ")");
        this.separator();
        this.newLine();
    }

    public void onFinish() {
        this.newLine();
        this.separator();
        this.debug("AFTER TEST SUITE");
        this.newLine();
    }

    public void onStart() {
        this.newLine();
        this.separator();
        this.info("       .__  __                       ");
        this.info("  ____ |__|/  |________ __ __  ______");
        this.info("_/ ___\\|  \\   __\\_  __ \\  |  \\/  ___/");
        this.info("\\  \\___|  ||  |  |  | \\/  |  /\\___ \\ ");
        this.info(" \\___  >__||__|  |__|  |____//____  >");
        this.info("     \\/                           \\/");
        this.newLine();
        this.info("C I T R U S  T E S T S  " + CitrusVersion.version());
        this.newLine();
        this.separator();
        this.debug("BEFORE TEST SUITE");
        this.newLine();
    }

    public void onFinishFailure(Throwable cause) {
        this.newLine();
        this.info("AFTER TEST SUITE: FAILED");
        this.separator();
        this.newLine();
    }

    public void onFinishSuccess() {
        this.newLine();
        this.info("AFTER TEST SUITE: SUCCESS");
        this.separator();
        this.newLine();
    }

    public void onStartFailure(Throwable cause) {
        this.newLine();
        this.info("BEFORE TEST SUITE: FAILED");
        this.separator();
        this.newLine();
    }

    public void onStartSuccess() {
        this.newLine();
        this.info("BEFORE TEST SUITE: SUCCESS");
        this.separator();
        this.newLine();
    }

    public void onTestActionStart(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("TEST STEP " + (testCase.getExecutedActions().size() + 1) + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            }
            if (testAction instanceof TestActionContainer) {
                this.debug("TEST ACTION CONTAINER with " + ((TestActionContainer)testAction).getActionCount() + " embedded actions");
            }
            if (testAction instanceof Described && StringUtils.hasText(((Described)testAction).getDescription())) {
                this.debug("");
                this.debug(((Described)testAction).getDescription());
                this.debug("");
            }
        }
    }

    public void onTestActionFinish(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("TEST STEP " + (testCase.getExecutedActions().size() + 1) + " SUCCESS");
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + " SUCCESS");
            }
        }
    }

    public void onTestActionSkipped(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("SKIPPING TEST STEP " + (testCase.getExecutedActions().size() + 1));
            } else {
                this.debug("SKIPPING TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount());
            }
            this.debug("TEST ACTION " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()) + " SKIPPED");
        }
    }

    public void onInboundMessage(Message message, TestContext context) {
        inboundMessageLogger.debug(message.print(context));
    }

    public void onOutboundMessage(Message message, TestContext context) {
        outboundMessageLogger.debug(message.print(context));
    }

    private void separator() {
        this.info("------------------------------------------------------------------------");
    }

    private void newLine() {
        this.info("");
    }

    protected void info(String line) {
        logger.info(line);
    }

    protected void error(String line, Throwable cause) {
        logger.error(line, cause);
    }

    protected void debug(String line) {
        if (this.isDebugEnabled()) {
            logger.debug(line);
        }
    }

    protected boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            logger = enabledLog;
            inboundMessageLogger = enabledInboundMessageLogger;
            outboundMessageLogger = enabledOutboundMessageLogger;
        } else {
            logger = noOpLogger;
            inboundMessageLogger = noOpLogger;
            outboundMessageLogger = noOpLogger;
        }
    }

    protected boolean isEnabled() {
        return logger != noOpLogger;
    }

    static {
        enabledInboundMessageLogger = inboundMessageLogger = LoggerFactory.getLogger((String)"Logger.Message_IN");
        enabledOutboundMessageLogger = outboundMessageLogger = LoggerFactory.getLogger((String)"Logger.Message_OUT");
        enabledLog = logger = LoggerFactory.getLogger(LoggingReporter.class);
        noOpLogger = new NOPLoggerFactory().getLogger(LoggingReporter.class.getName());
    }
}

