/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.CitrusContext;
import org.citrusframework.DefaultCitrusContextProvider;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface CitrusContextProvider {
    public static final Logger logger = LoggerFactory.getLogger(CitrusContextProvider.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/context/provider";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/context/provider");
    public static final String SPRING = "spring";

    public CitrusContext create();

    public static CitrusContextProvider lookup() {
        Map provider = TYPE_RESOLVER.resolveAll("", "*");
        if (provider.isEmpty()) {
            logger.debug("Using default Citrus context provider");
            return new DefaultCitrusContextProvider();
        }
        if (provider.size() > 1) {
            logger.warn(String.format("Found %d Citrus context provider implementations. Please choose one of them.", provider.size()));
        }
        if (logger.isDebugEnabled()) {
            provider.forEach((k, v) -> logger.debug(String.format("Found Citrus context provider '%s' as %s", k, v.getClass())));
        }
        CitrusContextProvider contextProvider = (CitrusContextProvider)provider.values().iterator().next();
        logger.debug(String.format("Using Citrus context provider '%s' as %s", provider.keySet().iterator().next(), contextProvider));
        return contextProvider;
    }

    public static Optional<CitrusContextProvider> lookup(String name) {
        try {
            CitrusContextProvider instance = (CitrusContextProvider)TYPE_RESOLVER.resolve(name, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn(String.format("Failed to resolve Citrus context provider from resource '%s/%s'", RESOURCE_PATH, name));
            return Optional.empty();
        }
    }
}

