/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.server.Server;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartServerAction
extends AbstractTestAction {
    private final List<Server> servers;
    private static final Logger logger = LoggerFactory.getLogger(StartServerAction.class);

    public StartServerAction(Builder builder) {
        super("start-server", builder);
        this.servers = builder.servers;
    }

    @Override
    public void doExecute(TestContext context) {
        for (Server server : this.servers) {
            server.start();
            logger.info("Started server: " + server.getName());
        }
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<StartServerAction, Builder>
    implements ReferenceResolverAware {
        private final List<Server> servers = new ArrayList<Server>();
        private final List<String> serverNames = new ArrayList<String>();
        private ReferenceResolver referenceResolver;

        public static Builder start() {
            return new Builder();
        }

        public static Builder start(Server ... servers) {
            Builder builder = new Builder();
            Stream.of(servers).forEach(builder::server);
            return builder;
        }

        public static Builder start(Server server) {
            Builder builder = new Builder();
            builder.server(server);
            return builder;
        }

        public static Builder start(String ... serverNames) {
            Builder builder = new Builder();
            Stream.of(serverNames).forEach(builder::server);
            return builder;
        }

        public static Builder start(String server) {
            Builder builder = new Builder();
            builder.server(server);
            return builder;
        }

        public Builder server(Server server) {
            this.servers.add(server);
            return this;
        }

        public Builder server(Server ... server) {
            return this.server(Arrays.asList(server));
        }

        public Builder server(List<Server> servers) {
            this.servers.addAll(servers);
            return this;
        }

        public Builder server(String server) {
            this.serverNames.add(server);
            return this;
        }

        public Builder server(String ... server) {
            return this.serverNames(Arrays.asList(server));
        }

        public Builder serverNames(List<String> servers) {
            this.serverNames.addAll(servers);
            return this;
        }

        public StartServerAction build() {
            if (this.referenceResolver != null) {
                for (String serverName : this.serverNames) {
                    this.server((Server)this.referenceResolver.resolve(serverName, Server.class));
                }
            }
            return new StartServerAction(this);
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }
    }
}

