/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import javax.net.ServerSocketFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class SocketUtils {
    private static final int PORT_RANGE_MIN = 1024;
    private static final int PORT_RANGE_MAX = 65535;
    private static final int MAX_ATTEMPTS = 1000;
    private static final Random random = new Random(System.nanoTime());

    public static int findAvailableTcpPort() {
        return SocketUtils.findAvailableTcpPort(1024);
    }

    public static int findAvailableTcpPort(int min) {
        int candidatePort;
        if (min < 1024) {
            throw new CitrusRuntimeException(String.format("Invalid minimum value for port range - ports range must be greater than %d", 1024));
        }
        int count = 0;
        do {
            if (++count <= 1000) continue;
            throw new CitrusRuntimeException(String.format("Could not find an available TCP port in the range [%d, %d] after %d attempts", min, 65535, 1000));
        } while (!SocketUtils.isPortAvailable(candidatePort = min + random.nextInt(65535 - min + 1)));
        return candidatePort;
    }

    private static boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

